/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29_00.pointer.StructurePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMGCSegregatedAllocationCacheEntryPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMGCSizeClassesPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionDescriptorSegregatedPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionListPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_LockingFreeHeapRegionListPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_LockingHeapRegionQueuePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_MemoryPoolAggregatedCellListPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_RealtimeGCPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_RegionPoolSegregatedPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29_00.structure.J9Consts;
import com.ibm.j9ddr.vm29_00.structure.MM_RegionPoolSegregated;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import java.io.PrintStream;

public class DumpSegregatedStatsCommand
extends Command {
    public DumpSegregatedStatsCommand() {
        this.addCommand("dumpsegregatedstats", "", "Print segregated heap statistics, similiar to -XXgc:gcbugheap");
    }

    public long getTotalRegions(MM_HeapRegionListPointer heapRegionList) throws CorruptDataException {
        long count = 0L;
        StructurePointer heapRegionQueue = heapRegionList.getAsRuntimeType();
        if (heapRegionQueue instanceof MM_LockingHeapRegionQueuePointer) {
            MM_LockingHeapRegionQueuePointer lockingHeapRegionQueue = (MM_LockingHeapRegionQueuePointer)heapRegionQueue;
            if (lockingHeapRegionQueue._singleRegionsOnly()) {
                count = lockingHeapRegionQueue._length().longValue();
            } else {
                MM_HeapRegionDescriptorSegregatedPointer heapRegionDescriptorSegregated = lockingHeapRegionQueue._head();
                while (heapRegionDescriptorSegregated.notNull()) {
                    count += heapRegionDescriptorSegregated._regionsInSpan().longValue();
                    heapRegionDescriptorSegregated = heapRegionDescriptorSegregated._next();
                }
            }
        } else if (heapRegionQueue instanceof MM_LockingFreeHeapRegionListPointer) {
            MM_LockingFreeHeapRegionListPointer lockingFreeHeapRegionQueue = (MM_LockingFreeHeapRegionListPointer)heapRegionQueue;
            MM_HeapRegionDescriptorSegregatedPointer heapRegionDescriptorSegregated = lockingFreeHeapRegionQueue._head();
            while (heapRegionDescriptorSegregated.notNull()) {
                count += heapRegionDescriptorSegregated._regionsInSpan().longValue();
                heapRegionDescriptorSegregated = heapRegionDescriptorSegregated._next();
            }
        } else {
            throw new CorruptDataException("Bad HeapRegionList type");
        }
        return count;
    }

    public long getFreeCellCount(MM_HeapRegionListPointer heapRegionList) throws CorruptDataException {
        StructurePointer heapRegionQueue = heapRegionList.getAsRuntimeType();
        long freeCellCount = 0L;
        if (heapRegionQueue instanceof MM_LockingHeapRegionQueuePointer) {
            MM_LockingHeapRegionQueuePointer lockingHeapRegionQueue = (MM_LockingHeapRegionQueuePointer)heapRegionQueue;
            MM_HeapRegionDescriptorSegregatedPointer heapRegionDescriptorSegregated = lockingHeapRegionQueue._head();
            while (heapRegionDescriptorSegregated.notNull()) {
                freeCellCount += this.getFreeCellCount(heapRegionDescriptorSegregated);
                heapRegionDescriptorSegregated = heapRegionDescriptorSegregated._next();
            }
        } else if (heapRegionQueue instanceof MM_LockingFreeHeapRegionListPointer) {
            MM_LockingFreeHeapRegionListPointer lockingFreeHeapRegionQueue = (MM_LockingFreeHeapRegionListPointer)heapRegionQueue;
            MM_HeapRegionDescriptorSegregatedPointer heapRegionDescriptorSegregated = lockingFreeHeapRegionQueue._head();
            while (heapRegionDescriptorSegregated.notNull()) {
                freeCellCount += this.getFreeCellCount(heapRegionDescriptorSegregated);
                heapRegionDescriptorSegregated = heapRegionDescriptorSegregated._next();
            }
        } else {
            throw new CorruptDataException("Bad HeapRegionList type");
        }
        return freeCellCount;
    }

    public long getFreeCellCount(MM_HeapRegionDescriptorSegregatedPointer heapRegionDescriptor) throws CorruptDataException {
        MM_MemoryPoolAggregatedCellListPointer memoryPoolACL = heapRegionDescriptor._memoryPoolACL();
        GCHeapLinkedFreeHeader heapLinkedFreeHeader = GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(memoryPoolACL._freeListHead());
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9VMGCSizeClassesPointer sizeClasses = vm.realtimeSizeClasses();
        UDATA sizeClassIndex = heapRegionDescriptor._sizeClass();
        long cellSize = sizeClasses.smallCellSizesEA().at(sizeClassIndex).longValue();
        long freeCellCount = 0L;
        while (heapLinkedFreeHeader.getHeader().notNull()) {
            freeCellCount += heapLinkedFreeHeader.getSize().longValue() / cellSize;
            heapLinkedFreeHeader = heapLinkedFreeHeader.getNext();
        }
        return freeCellCount;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (!GCExtensions.isSegregatedHeap()) {
            out.append("Only valid for a segregated heap\n");
            return;
        }
        try {
            MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
            MM_RealtimeGCPointer realtimeGC = MM_RealtimeGCPointer.cast(extensions._globalCollector());
            MM_RegionPoolSegregatedPointer regionPool = realtimeGC._memoryPool()._regionPool();
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMGCSizeClassesPointer sizeClasses = vm.realtimeSizeClasses();
            long countTotal = 0L;
            long countAvailableSmallTotal = 0L;
            long countFullSmallTotal = 0L;
            long darkMatterBytesTotal = 0L;
            long allocCacheBytesTotal = 0L;
            long arrayOffset = J9Consts.J9VMGC_SIZECLASSES_MIN_SMALL * MM_RegionPoolSegregated.NUM_DEFRAG_BUCKETS;
            out.append("sizeClass | full | available           | total | free cell count | dark | cache\n");
            out.append("===============================================================================\n");
            for (long sizeClassIndex = J9Consts.J9VMGC_SIZECLASSES_MIN_SMALL; sizeClassIndex <= J9Consts.J9VMGC_SIZECLASSES_MAX_SMALL; ++sizeClassIndex) {
                UDATA cellSize = sizeClasses.smallCellSizesEA().at(sizeClassIndex);
                out.format("%2d: %5d | ", sizeClassIndex, cellSize.longValue());
                MM_HeapRegionListPointer heapRegionQueue = MM_HeapRegionListPointer.cast(regionPool._smallFullRegionsEA().at(sizeClassIndex));
                long countSmall = this.getTotalRegions(heapRegionQueue);
                countFullSmallTotal += countSmall;
                out.format("%4d | ", countSmall);
                long freeCellCount = 0L;
                for (long i = 0L; i < MM_RegionPoolSegregated.NUM_DEFRAG_BUCKETS; ++i) {
                    long count = 0L;
                    MM_LockingHeapRegionQueuePointer heapRegionList = MM_LockingHeapRegionQueuePointer.cast(regionPool._smallAvailableRegionsEA().add(arrayOffset).at(0L));
                    for (long j = 0L; j < regionPool._splitAvailableListSplitCount().longValue(); ++j) {
                        count += this.getTotalRegions(heapRegionList);
                        freeCellCount += this.getFreeCellCount(heapRegionList);
                        heapRegionList = heapRegionList.add(1L);
                    }
                    ++arrayOffset;
                    countSmall += count;
                    countAvailableSmallTotal += count;
                    out.format("%4d ", count);
                }
                countTotal += countSmall;
                out.format("| %5d | %15d |", countSmall, freeCellCount);
                long darkMatterCellCount = regionPool._darkMatterCellCountEA().at(sizeClassIndex).longValue();
                darkMatterBytesTotal += darkMatterCellCount * cellSize.longValue();
                out.format("%%%3d | ", countSmall == 0L ? 0L : darkMatterCellCount / (countSmall * cellSize.longValue()));
                long allocCacheSize = 0L;
                J9VMThreadPointer mainThread = vm.mainThread();
                if (mainThread.notNull()) {
                    J9VMThreadPointer threadCursor = vm.mainThread();
                    do {
                        J9VMGCSegregatedAllocationCacheEntryPointer cache = threadCursor.segregatedAllocationCache();
                        cache = cache.add(sizeClassIndex);
                        allocCacheSize += cache.top().longValue() - cache.current().longValue();
                    } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
                }
                out.format("%5d\n", allocCacheSize);
                allocCacheBytesTotal += allocCacheSize;
            }
            long regionSize = extensions.heap()._heapRegionManager()._regionSize().longValue();
            out.format("region size %d\n", regionSize);
            long arrayletLeafSize = extensions._omrVM()._arrayletLeafSize().longValue();
            out.format("arraylet leaf size %d\n", arrayletLeafSize);
            out.format("small total (full, available) region count %d (%d, %d)\n", countTotal, countFullSmallTotal, countAvailableSmallTotal);
            long countFullArraylet = this.getTotalRegions(regionPool._arrayletFullRegions());
            long countAvailArraylet = this.getTotalRegions(regionPool._arrayletAvailableRegions());
            long countTotalArraylet = countFullArraylet + countAvailArraylet;
            countTotal += countTotalArraylet;
            out.format("arraylet total (full, available) region count %d (%d %d)\n", countTotalArraylet, countFullArraylet, countAvailArraylet);
            long countLarge = this.getTotalRegions(regionPool._largeFullRegions());
            countTotal += countLarge;
            out.format("large full region count %d\n", countLarge);
            long countFree = this.getTotalRegions(regionPool._singleFreeList());
            countTotal += countFree;
            out.format("free region count %d\n", countFree);
            long countMultiFree = this.getTotalRegions(regionPool._multiFreeList());
            countTotal += countMultiFree;
            out.format("multiFree region count %d\n", countMultiFree);
            long countCoalesce = this.getTotalRegions(regionPool._coalesceFreeList());
            out.format("coalesce region count %d\n", countCoalesce);
            long heapSize = (countTotal += countCoalesce) * regionSize;
            out.format("total region count %d, total heap size %d \n", countTotal, heapSize);
            out.format("dark matter total bytes %d (%2.2f%% of heap)\n", darkMatterBytesTotal, 100.0 * (double)darkMatterBytesTotal / (double)heapSize);
            out.format("allocation cache total bytes %d (%2.2f%% of heap)\n", allocCacheBytesTotal, 100.0 * (double)allocCacheBytesTotal / (double)heapSize);
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }
}

