/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.JVMTIObjectTagTable;
import com.ibm.j9ddr.vm28.j9.gc.GCIterator;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9JVMTIObjectTagPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GCJVMTIObjectTagTableIterator
extends GCIterator {
    protected Iterator<J9JVMTIObjectTagPointer> hashTableIterator;

    protected GCJVMTIObjectTagTableIterator(J9JVMTIEnvPointer jvmtiEnv) throws CorruptDataException {
        this.hashTableIterator = JVMTIObjectTagTable.fromJ9JVMTIEnv(jvmtiEnv).iterator();
    }

    public static GCJVMTIObjectTagTableIterator fromJ9JVMTIEnv(J9JVMTIEnvPointer jvmtiEnv) throws CorruptDataException {
        return new GCJVMTIObjectTagTableIterator(jvmtiEnv);
    }

    @Override
    public boolean hasNext() {
        return this.hashTableIterator.hasNext();
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            try {
                J9JVMTIObjectTagPointer objTag = this.hashTableIterator.next();
                return objTag.ref();
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            try {
                J9JVMTIObjectTagPointer objTag = this.hashTableIterator.next();
                return VoidPointer.cast(objTag.refEA());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

