/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.vm27.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.WideSelfRelativePointer;
import java.io.PrintStream;

public class J9SRPFormatter
extends BaseFieldFormatter {
    private final int typeCode;
    private final String srpPrefix;
    private final boolean wide;

    public J9SRPFormatter(int typeCode, String srpPrefix, boolean wide) {
        this.typeCode = typeCode;
        this.srpPrefix = srpPrefix;
        this.wide = wide;
    }

    private String stripSRP(String type2) {
        type2 = type2.trim();
        return type2.substring(this.srpPrefix.length(), type2.length() - 1);
    }

    @Override
    public FormatWalkResult format(String name, String type2, String declaredType, int thisTypeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        if (thisTypeCode != this.typeCode) {
            return FormatWalkResult.KEEP_WALKING;
        }
        VoidPointer targetAddress = VoidPointer.NULL;
        if (this.wide) {
            WideSelfRelativePointer s = WideSelfRelativePointer.cast(address);
            targetAddress = s.get();
        } else {
            SelfRelativePointer s = SelfRelativePointer.cast(address);
            targetAddress = s.get();
        }
        if (type2.contains("(")) {
            type2 = this.stripSRP(type2);
            structureFormatter.formatField(name, type2, type2, targetAddress.getAddress(), out, context);
        } else {
            out.print("!j9x ");
            out.print(targetAddress.getHexAddress());
        }
        return FormatWalkResult.STOP_WALKING;
    }
}

