/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm27.structure.J9Object;
import com.ibm.j9ddr.vm27.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;

public class J9ClassShapeCommand
extends Command {
    public J9ClassShapeCommand() {
        this.addCommand("j9classshape", "<ramclass>", "view instance shape");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            CommandUtils.dbgPrint(out, "Usage: !j9classshape <classAddress>\n");
            return;
        }
        try {
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9ClassPointer instanceClass = J9ClassPointer.cast(address);
            J9ClassPointer previousSuperclass = J9ClassPointer.NULL;
            String className = J9ClassHelper.getName(instanceClass);
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            boolean lockwordPrinted = true;
            if (J9BuildFlags.thr_lockNursery) {
                lockwordPrinted = false;
            }
            CommandUtils.dbgPrint(out, "Instance fields in %s:\n", className);
            CommandUtils.dbgPrint(out, "\noffset     name\tsignature\t(declaring class)\n");
            if (mainThread.isNull()) {
                return;
            }
            long depth = J9ClassHelper.classDepth(instanceClass).longValue();
            for (long superclassIndex = 0L; superclassIndex <= depth; ++superclassIndex) {
                J9ClassPointer superclass = superclassIndex == depth ? instanceClass : J9ClassPointer.cast(instanceClass.superclasses().at(superclassIndex));
                U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
                Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(superclass.romClass(), instanceClass, previousSuperclass, flags);
                while (iterator.hasNext()) {
                    J9ObjectFieldOffset result = iterator.next();
                    boolean printField = true;
                    boolean isHiddenField = result.isHidden();
                    if (J9BuildFlags.thr_lockNursery) {
                        boolean isLockword;
                        boolean bl = isLockword = isHiddenField && result.getOffsetOrAddress().add(J9Object.SIZEOF).eq(superclass.lockOffset());
                        if (isLockword) {
                            boolean bl2 = printField = !lockwordPrinted && instanceClass.lockOffset().eq(superclass.lockOffset());
                            if (printField) {
                                lockwordPrinted = true;
                            }
                        }
                    }
                    if (!printField) continue;
                    this.printShapeField(out, superclass, result.getField(), result.getOffsetOrAddress(), isHiddenField);
                }
                previousSuperclass = superclass;
            }
            CommandUtils.dbgPrint(out, "\nTotal instance size: %d\n", instanceClass.totalInstanceSize().longValue());
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printShapeField(PrintStream out, J9ClassPointer fromClass, J9ROMFieldShapePointer field, UDATA offset, boolean isHiddenField) throws CorruptDataException {
        String name = J9ROMFieldShapeHelper.getName(field);
        String signature = J9ROMFieldShapeHelper.getSignature(field);
        String className = J9UTF8Helper.stringValue(fromClass.romClass().className());
        CommandUtils.dbgPrint(out, "%d\t%s\t%s\t(%s)%s\n", offset.longValue(), name, signature, className, isHiddenField ? " <hidden>" : "");
    }
}

