/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm24.j9.ObjectModel;
import com.ibm.j9ddr.vm24.pointer.I32Pointer;
import com.ibm.j9ddr.vm24.pointer.I64Pointer;
import com.ibm.j9ddr.vm24.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.types.U32;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9ObjectHelper {
    public static boolean isIndexable(J9ObjectPointer objPointer) throws CorruptDataException {
        return ObjectModel.isIndexable(objPointer);
    }

    public static U32 flags(J9ObjectPointer objPointer) throws CorruptDataException {
        return objPointer.flags();
    }

    public static J9ClassPointer clazz(J9ObjectPointer objPointer) throws CorruptDataException {
        return objPointer.clazz();
    }

    public static String getClassName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getName(J9ObjectHelper.clazz(objPointer));
    }

    public static String getJavaName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getJavaName(J9ObjectHelper.clazz(objPointer));
    }

    public static String stringValue(J9ObjectPointer objPointer) throws CorruptDataException {
        if (!J9ObjectHelper.getClassName(objPointer).equals("java/lang/String")) {
            throw new IllegalArgumentException();
        }
        J9ObjectPointer charsObject = J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[C"));
        J9IndexableObjectPointer charsArray = J9IndexableObjectPointer.cast(charsObject);
        char[] value = (char[])J9IndexableObjectHelper.getData(charsArray);
        int offset = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "offset", "I"));
        int count = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "count", "I"));
        return new String(value, offset, count);
    }

    public static String getStringField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        J9ObjectPointer stringObject = J9ObjectHelper.getObjectField(objPointer, offset);
        if (stringObject.isNull()) {
            return null;
        }
        return J9ObjectHelper.stringValue(stringObject);
    }

    public static int getIntField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I32Pointer pointer = offset.isStatic() ? I32Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : I32Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(J9Object.SIZEOF));
        return pointer.at(0L).intValue();
    }

    public static short getShortField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (short)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static float getFloatField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        int data = J9ObjectHelper.getIntField(objPointer, offset);
        return Float.intBitsToFloat(data);
    }

    public static double getDoubleField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        long data = J9ObjectHelper.getLongField(objPointer, offset);
        return Double.longBitsToDouble(data);
    }

    public static char getCharField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (char)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static byte getByteField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (byte)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFF);
    }

    public static boolean getBooleanField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return J9ObjectHelper.getIntField(objPointer, offset) != 0;
    }

    public static long getLongField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I64Pointer pointer = offset.isStatic() ? I64Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : I64Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(J9Object.SIZEOF));
        return pointer.at(0L).longValue();
    }

    public static J9ObjectPointer getObjectField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        if (offset.isStatic()) {
            UDATAPointer pointer = J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress());
            return J9ObjectPointer.cast(pointer.at(0L));
        }
        return ObjectReferencePointer.cast(objPointer.add(1L).addOffset(offset.getOffsetOrAddress())).at(0L);
    }

    public static J9ObjectFieldOffset getFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ObjectFieldOffset result = J9ClassHelper.checkFieldOffsetCache(J9ObjectHelper.clazz(objPointer), name, signature);
        if (result == null) {
            result = J9ObjectHelper.readFieldOffset(objPointer, name, signature);
            J9ClassHelper.setFieldOffsetCache(J9ObjectHelper.clazz(objPointer), result, name, signature);
        }
        return result;
    }

    private static J9ObjectFieldOffset readFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ClassPointer currentClass = J9ObjectHelper.clazz(objPointer);
        while (currentClass.notNull()) {
            Iterator<J9ObjectFieldOffset> fields = J9ClassHelper.getFieldOffsets(currentClass);
            while (fields.hasNext()) {
                J9ObjectFieldOffset field = fields.next();
                if (!field.getName().equals(name) || !field.getSignature().equals(signature)) continue;
                return field;
            }
            currentClass = J9ClassHelper.superclass(currentClass);
        }
        throw new NoSuchElementException(String.format("No field named %s with signature %s in %s", name, signature, J9ObjectHelper.getClassName(objPointer)));
    }
}

