/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import java.util.Properties;

public class J9DDRImageSection
implements ImageSection {
    private final IProcess proc;
    private final long address;
    private J9DDRImagePointer baseAddress = null;
    private long size = 0L;
    private final String name;

    public J9DDRImageSection(IProcess proc, long address, String name) {
        this.proc = proc;
        this.address = address;
        this.name = name != null ? name : "Image section @ " + Long.toHexString(this.getBaseAddress().getAddress());
    }

    public J9DDRImageSection(IProcess proc, long address, long size, String name) {
        this.proc = proc;
        this.address = address;
        this.size = size;
        this.name = name != null ? name : "Image section @ " + Long.toHexString(address) + " (" + this.getSize() + " bytes)";
    }

    public J9DDRImagePointer getBaseAddress() {
        if (this.baseAddress == null) {
            this.baseAddress = new J9DDRImagePointer(this.proc, this.address);
        }
        return this.baseAddress;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isExecutable() throws DataUnavailable {
        return this.getBaseAddress().isExecutable();
    }

    public boolean isReadOnly() throws DataUnavailable {
        return this.getBaseAddress().isReadOnly();
    }

    public boolean isShared() throws DataUnavailable {
        return this.getBaseAddress().isShared();
    }

    public Properties getProperties() {
        return this.getBaseAddress().getProperties();
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("ImageSection [0x");
        data.append(Long.toHexString(this.address));
        data.append(" - 0x");
        data.append(Long.toHexString(this.address + this.size));
        data.append("]");
        return data.toString();
    }
}

