/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class J9DDRImageAddressSpace
implements ImageAddressSpace {
    private final IAddressSpace as;

    public J9DDRImageAddressSpace(IAddressSpace as) {
        this.as = as;
    }

    public IAddressSpace getIAddressSpace() {
        return this.as;
    }

    public ByteOrder getByteOrder() {
        return this.as.getByteOrder();
    }

    public J9DDRImageProcess getCurrentProcess() {
        Iterator<J9DDRImageProcess> processesIt = this.getProcesses();
        J9DDRImageProcess first = null;
        while (processesIt.hasNext()) {
            J9DDRImageProcess p = processesIt.next();
            try {
                if (p.isFailingProcess()) {
                    return p;
                }
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
            if (first != null) continue;
            first = p;
        }
        return first;
    }

    public Iterator<?> getImageSections() {
        Collection<? extends IMemoryRange> ranges = this.as.getMemoryRanges();
        ArrayList<J9DDRImageSection> sections = new ArrayList<J9DDRImageSection>(ranges.size());
        IProcess proc = this.getPointerProcess();
        if (null == proc) {
            return J9DDRDTFJUtils.emptyIterator();
        }
        for (IMemoryRange iMemoryRange : ranges) {
            J9DDRImageSection section = new J9DDRImageSection(proc, iMemoryRange.getBaseAddress(), iMemoryRange.getSize(), iMemoryRange.getName());
            sections.add(section);
        }
        return sections.iterator();
    }

    public ImagePointer getPointer(long address) {
        return new J9DDRImagePointer(this.getPointerProcess(), address);
    }

    private IProcess getPointerProcess() {
        Iterator<? extends IProcess> procs = this.as.getProcesses().iterator();
        IProcess process = null;
        while (procs.hasNext()) {
            process = procs.next();
            if (process.bytesPerPointer() != 8) continue;
            return process;
        }
        return process;
    }

    public Iterator<J9DDRImageProcess> getProcesses() {
        Collection<? extends IProcess> processes = this.as.getProcesses();
        LinkedList<J9DDRImageProcess> dtfjList = new LinkedList<J9DDRImageProcess>();
        for (IProcess iProcess : processes) {
            dtfjList.add(new J9DDRImageProcess(iProcess));
        }
        return dtfjList.iterator();
    }

    public String getID() {
        return "0x" + Long.toHexString(this.as.getAddressSpaceId());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof J9DDRImageAddressSpace)) {
            return false;
        }
        J9DDRImageAddressSpace space = (J9DDRImageAddressSpace)obj;
        return this.as.equals(space.as);
    }

    public int hashCode() {
        return this.as.getAddressSpaceId();
    }

    public String toString() {
        return "AddressSpace id 0x" + Integer.toHexString(this.as.getAddressSpaceId());
    }

    public Properties getProperties() {
        return new Properties();
    }
}

