/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapBaseCommand;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TracePointImpl;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SnapFormatCommand
extends SnapBaseCommand {
    private TraceContext traceContext = null;
    private final List<InputStream> messageFiles = new ArrayList<InputStream>();
    private boolean outputHeader = true;
    private static final String[] MESSAGEFILENAMES = new String[]{"TraceFormat.dat", "J9TraceFormat.dat", "OMRTraceFormat.dat"};
    private static final String[] DEFAULTMESSAGEFILEPATHS = new String[]{System.getProperty("user.dir"), System.getProperty("java.home") + File.separator + "lib"};

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        String leader;
        String fileName = null;
        String userDatPath = null;
        String userThreadId = null;
        String messageFilePath = null;
        ArrayList<String> messageFileStrings = new ArrayList<String>();
        TraceFilterExpression specFilter = null;
        if (args.length == 0) {
            fileName = null;
        } else if (args.length == 1) {
            fileName = args[0];
        } else {
            int i = 0;
            while (i < args.length - 1) {
                String flag = args[i++];
                String value = args[i++];
                if ("-f".equals(flag)) {
                    fileName = value;
                    continue;
                }
                if ("-d".equals(flag)) {
                    userDatPath = value;
                    continue;
                }
                if ("-t".equals(flag)) {
                    userThreadId = value;
                    this.outputHeader = false;
                    continue;
                }
                if (!"-s".equals(flag)) continue;
                specFilter = TraceFilterExpression.parseExpression(value);
                this.outputHeader = false;
            }
        }
        if (userDatPath != null) {
            messageFilePath = userDatPath;
            for (String name : MESSAGEFILENAMES) {
                File f = new File(userDatPath, name);
                if (!f.exists()) continue;
                try {
                    this.messageFiles.add(new FileInputStream(f));
                    messageFileStrings.add(name);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        } else {
            for (String name : MESSAGEFILENAMES) {
                String[] s = TraceContext.class.getResourceAsStream('/' + name);
                if (s == null) continue;
                this.messageFiles.add((InputStream)s);
                messageFileStrings.add(TraceContext.class.getResource('/' + name).toString());
            }
            if (this.messageFiles.isEmpty()) {
                for (String path : DEFAULTMESSAGEFILEPATHS) {
                    for (String name : MESSAGEFILENAMES) {
                        File f = new File(path, name);
                        if (!f.exists()) continue;
                        try {
                            this.messageFiles.add(new FileInputStream(f));
                            messageFileStrings.add(name);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (this.messageFiles.isEmpty()) continue;
                    messageFilePath = path;
                    break;
                }
            }
        }
        if (this.messageFiles.isEmpty()) {
            leader = "Unable to find any of";
            for (String name : MESSAGEFILENAMES) {
                out.printf("%s %s", leader, name);
                leader = ",";
            }
            if (messageFilePath != null) {
                out.printf(" in %s%n", messageFilePath);
            } else {
                out.printf(" in %s or %s%n", DEFAULTMESSAGEFILEPATHS[0], DEFAULTMESSAGEFILEPATHS[1]);
            }
            return;
        }
        leader = "Formatting trace using format dat files";
        for (String name : messageFileStrings) {
            out.printf("%s %s", leader, name);
            leader = ",";
        }
        if (messageFilePath != null) {
            out.printf(" from %s%n", messageFilePath);
        } else {
            out.println();
        }
        if (this.outputHeader) {
            this.extractTraceData(context, out);
        } else {
            PrintStream dummyOut = new PrintStream(new OutputStream(){

                @Override
                public void write(int octet) {
                }
            });
            this.extractTraceData(context, dummyOut);
        }
        if (this.traceContext == null) {
            out.println("Unable to create trace context, command failed.");
            return;
        }
        long threadId = 0L;
        if (userThreadId != null) {
            boolean is64BitPlatform = context.process.bytesPerPointer() == 8;
            threadId = CommandUtils.parsePointer(userThreadId, is64BitPlatform);
        }
        PrintStream traceOut = out;
        PrintStream filePrintStream = null;
        if (fileName != null) {
            try {
                traceOut = filePrintStream = new PrintStream(fileName);
            }
            catch (FileNotFoundException e) {
                out.printf("Unable to write formatted trace to file %s\n", fileName);
            }
        }
        if (this.outputHeader) {
            traceOut.println(this.traceContext.summary());
        }
        try {
            Iterator tpIterator = null;
            if (userThreadId != null) {
                Iterator threadsIterator = this.traceContext.getThreads();
                boolean foundThread = false;
                while (threadsIterator.hasNext()) {
                    TraceThread thread = (TraceThread)threadsIterator.next();
                    if (thread.getThreadID() != threadId) continue;
                    foundThread = true;
                    tpIterator = thread.getIterator();
                }
                if (!foundThread) {
                    out.printf("Unable to find thread %s in trace data\n", userThreadId);
                }
            } else {
                tpIterator = this.traceContext.getTracepoints();
            }
            if (tpIterator != null) {
                int tpCount = this.printTracePoints(traceOut, tpIterator, specFilter);
                out.printf("Completed processing of %d tracepoints with %d warnings and %d errors\n", this.traceContext.getTotalTracePoints(), this.traceContext.getWarningCount(), this.traceContext.getErrorCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (filePrintStream != null) {
            out.println("Snap trace written to: " + fileName);
            filePrintStream.close();
        }
    }

    private int printTracePoints(PrintStream traceOut, Iterator<TracePoint> tpIterator, TraceFilterExpression specFilter) {
        int tpCount = 0;
        TraceThread thread = null;
        while (tpIterator.hasNext()) {
            TracePoint tp = tpIterator.next();
            TracePointImpl tracepoint = null;
            if (tp instanceof TracePointImpl) {
                tracepoint = (TracePointImpl)tp;
            }
            if (tracepoint == null || specFilter != null && !specFilter.matches((TracePoint)tracepoint)) continue;
            TraceThread current = tracepoint.getThread();
            String component = tracepoint.getComponentName();
            int tpID = tracepoint.getID();
            String container = tracepoint.getContainerComponent();
            ++tpCount;
            String parameters = "";
            try {
                parameters = tracepoint.getFormattedParameters();
                if (parameters == null || parameters.length() == 0) {
                    this.traceContext.error((Object)this.traceContext, (Object)("null parameter data for trace point " + component + "." + tpID));
                }
            }
            catch (BufferUnderflowException e) {
                this.traceContext.error((Object)this.traceContext, (Object)("Underflow accessing parameter data for trace point " + component + "." + tpID));
            }
            StringBuilder formatted = new StringBuilder();
            formatted.append(tracepoint.getFormattedTime());
            formatted.append(" ").append(current != thread ? "*" : " ");
            formatted.append(String.format("0x%X", current.getThreadID()));
            formatted.append(" ");
            StringBuilder fullTracepointID = new StringBuilder(component);
            fullTracepointID.append(container != null ? "(" + container + ")" : "").append(".").append(tpID);
            formatted.append(String.format("%-20s", fullTracepointID.toString()));
            formatted.append(" ");
            formatted.append(tracepoint.getType());
            formatted.append(parameters.length() > 0 ? (parameters.charAt(0) == '*' ? " " : "") + parameters : "");
            thread = current;
            traceOut.println(formatted.toString());
        }
        return tpCount;
    }

    @Override
    protected void writeHeaderBytesToTrace(Context context, byte[] headerBytes, PrintStream out) {
        try {
            this.traceContext = TraceContext.getContext((byte[])headerBytes, (int)headerBytes.length, (InputStream)this.messageFiles.get(0));
            int n = this.messageFiles.size();
            for (int i = 1; i < n; ++i) {
                this.traceContext.addMessageData(this.messageFiles.get(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void writeBytesToTrace(Context context, long address, int bufferSize, PrintStream out) {
        if (this.traceContext == null) {
            out.println("Error - trace buffer passed before context created.");
            return;
        }
        byte[] data = new byte[bufferSize];
        try {
            context.process.getBytesAt(address, data);
        }
        catch (CorruptDataException e) {
            out.println("Problem reading " + bufferSize + " bytes from 0x" + Long.toHexString(address) + ". Trace file may contain partial or damaged data.");
        }
        this.traceContext.addData(data);
    }

    private static final class TraceFilter
    extends TraceFilterExpression {
        private String component = null;
        private String type = null;
        private int idLow = -1;
        private int idHigh = -1;

        public TraceFilter(String spec) {
            int index = 0;
            int typeIndex = spec.indexOf(123, index);
            if (-1 == typeIndex) {
                int dotIndex = spec.indexOf(46, index);
                if (-1 == dotIndex) {
                    this.component = spec.substring(index);
                } else {
                    this.component = spec.substring(index, dotIndex);
                    int dashIndex = spec.indexOf(45, dotIndex);
                    if (-1 == dashIndex) {
                        this.idHigh = this.idLow = Integer.parseInt(spec.substring(dotIndex + 1));
                    } else {
                        this.idLow = Integer.parseInt(spec.substring(dotIndex + 1, dashIndex));
                        this.idHigh = Integer.parseInt(spec.substring(dashIndex + 1));
                    }
                }
            } else {
                this.component = spec.substring(index, typeIndex);
                this.type = spec.substring(typeIndex + 1, spec.length() - 1);
            }
            if (null != this.component && (0 == this.component.length() || this.component.equalsIgnoreCase("all"))) {
                this.component = null;
            }
        }

        @Override
        public boolean matches(TracePoint tp) {
            boolean result = true;
            if (null != this.component) {
                if (this.component.equals(tp.getComponent())) {
                    int id;
                    if (-1 != this.idLow && ((id = tp.getID()) < this.idLow || id > this.idHigh)) {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
            if (result && null != this.type && !this.type.equalsIgnoreCase(tp.getType().trim())) {
                result = false;
                String[] groups = tp.getGroups();
                if (null != groups) {
                    for (int i = 0; i < groups.length; ++i) {
                        if (!this.type.equalsIgnoreCase(groups[i])) continue;
                        result = true;
                        break;
                    }
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (null != this.component) {
                builder.append(this.component);
                if (-1 != this.idLow) {
                    builder.append(".");
                    builder.append(this.idLow);
                    if (this.idLow != this.idHigh) {
                        builder.append("-");
                        builder.append(this.idHigh);
                    }
                }
            } else {
                builder.append("all");
            }
            if (null != this.type) {
                builder.append("{");
                builder.append(this.type);
                builder.append("}");
            }
            return builder.toString();
        }
    }

    private static final class TraceFilterAndExpression
    extends TraceFilterExpression {
        private final TraceFilterExpression lhs;
        private final TraceFilterExpression rhs;

        public TraceFilterAndExpression(TraceFilterExpression lhs, TraceFilterExpression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean matches(TracePoint tp) {
            if (this.lhs.matches(tp)) {
                return this.rhs.matches(tp);
            }
            return false;
        }

        public String toString() {
            return "(" + this.lhs + "&" + this.rhs + ")";
        }
    }

    private static abstract class TraceFilterExpression {
        TraceFilterExpression() {
        }

        public abstract boolean matches(TracePoint var1);

        public static TraceFilterExpression parseExpression(String expression) {
            StringTokenizer toker = new StringTokenizer(expression, "()&|!,", true);
            ArrayList<String> tokens = new ArrayList<String>();
            while (toker.hasMoreTokens()) {
                String token = toker.nextToken().trim();
                if (0 == token.length()) continue;
                if (token.equals(",")) {
                    tokens.add("|");
                    continue;
                }
                tokens.add(token);
            }
            TraceFilterExpression result = TraceFilterExpression.parseExpression(tokens);
            if (!tokens.isEmpty()) {
                throw new IllegalArgumentException("Failed to parse filter expression: unparsed text");
            }
            return result;
        }

        private static TraceFilterExpression parseExpression(List<String> tokens) {
            String token;
            TraceFilterExpression result = TraceFilterExpression.parseTerm(tokens);
            while (!tokens.isEmpty() && ((token = tokens.get(0)).equals("|") || token.equals(","))) {
                tokens.remove(0);
                TraceFilterExpression lhs = result;
                TraceFilterExpression rhs = TraceFilterExpression.parseTerm(tokens);
                result = new TraceFilterOrExpression(lhs, rhs);
            }
            return result;
        }

        private static TraceFilterExpression parseTerm(List<String> tokens) {
            String token;
            TraceFilterExpression result = TraceFilterExpression.parsePrimary(tokens);
            while (!tokens.isEmpty() && (token = tokens.get(0)).equals("&")) {
                tokens.remove(0);
                TraceFilterExpression lhs = result;
                TraceFilterExpression rhs = TraceFilterExpression.parsePrimary(tokens);
                result = new TraceFilterAndExpression(lhs, rhs);
            }
            return result;
        }

        private static TraceFilterExpression parsePrimary(List<String> tokens) {
            TraceFilterExpression result = null;
            if (tokens.isEmpty()) {
                throw new IllegalArgumentException("Failed to parse filter expression: expected expression");
            }
            String token = tokens.get(0);
            if (token.equals("(")) {
                tokens.remove(0);
                result = TraceFilterExpression.parseExpression(tokens);
                if (tokens.isEmpty() || !tokens.get(0).equals(")")) {
                    throw new IllegalArgumentException("Failed to parse filter expression: expected closing parenthesis");
                }
                tokens.remove(0);
            } else if (token.equals("!")) {
                tokens.remove(0);
                result = TraceFilterExpression.parsePrimary(tokens);
                result = new TraceFilterNotExpression(result);
            } else {
                if (token.equals(")") || token.equals("&") || token.equals("|") || token.equals(",")) {
                    throw new IllegalArgumentException("Failed to parse filter expression: expected expression, found " + token);
                }
                tokens.remove(0);
                result = new TraceFilter(token);
            }
            return result;
        }
    }

    private static final class TraceFilterNotExpression
    extends TraceFilterExpression {
        private final TraceFilterExpression expression;

        public TraceFilterNotExpression(TraceFilterExpression expression) {
            this.expression = expression;
        }

        @Override
        public boolean matches(TracePoint tp) {
            return !this.expression.matches(tp);
        }

        public String toString() {
            return "!" + this.expression;
        }
    }

    private static final class TraceFilterOrExpression
    extends TraceFilterExpression {
        private final TraceFilterExpression lhs;
        private final TraceFilterExpression rhs;

        public TraceFilterOrExpression(TraceFilterExpression lhs, TraceFilterExpression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean matches(TracePoint tp) {
            return this.lhs.matches(tp) || this.rhs.matches(tp);
        }

        public String toString() {
            return "(" + this.lhs + "|" + this.rhs + ")";
        }
    }
}

