/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.tools.ddrinteractive.ExpressionEvaluatorException;
import java.util.ArrayList;

public class ExpressionEvaluator {
    private static final String _UNARY_OPERATORS = "+-";
    private static final String[] _BINARY_OPERATORS_IN_PRECEDENCE = new String[]{"*/%", "+-"};
    private static final String _LEFT_PARENTHESES = "{[(<";
    private static final String _RIGHT_PARENTHESES = "}])>";
    private static final String _HEXADECIMAL_INDICATOR = "0x";
    private static final String _DECIMAL_INDICATOR = "d";
    private static final String _BINARY_INDICATOR = "bi";
    private final ArrayList<String> _al;

    public ExpressionEvaluator(String s) {
        this(new String[]{s});
    }

    public ExpressionEvaluator(String[] as) {
        this._al = this.format(as);
    }

    public ExpressionEvaluator(ArrayList<String> al) {
        this._al = this.format(al);
    }

    public static long eval(String exp) throws ExpressionEvaluatorException {
        return ExpressionEvaluator.eval(exp, 10);
    }

    public static long eval(String exp, int defaultRadix) throws ExpressionEvaluatorException {
        return new ExpressionEvaluator(exp).calculate(defaultRadix);
    }

    public long calculate(int defaultRadix) throws ExpressionEvaluatorException {
        try {
            return this.calculate(0, this._al.size() - 1, defaultRadix);
        }
        catch (NumberFormatException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (NullPointerException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    private long calculate(int startIndex, int endIndex, int defaultRadix) throws ExpressionEvaluatorException {
        if (startIndex == endIndex) {
            return this.evaluateToken(this._al.get(startIndex), defaultRadix);
        }
        ArrayList<Range> topLevelRanges = this.topLevelRanges(startIndex, endIndex);
        ArrayList<String> topLevel = this.topLevel(topLevelRanges, defaultRadix);
        return this.calculateTopLevel(topLevel);
    }

    private ArrayList<Range> topLevelRanges(int startIndex, int endIndex) throws ExpressionEvaluatorException {
        ArrayList<Range> topLevelRanges = new ArrayList<Range>();
        int index = startIndex;
        while (index <= endIndex) {
            String s = this._al.get(index);
            if (this.isLeftParenthesis(s)) {
                int rightIndex = this.findRightParenthesisIndex(index + 1, endIndex);
                topLevelRanges.add(new Range(index + 1, rightIndex - 1));
                index = rightIndex + 1;
                continue;
            }
            topLevelRanges.add(new Range(index, index));
            ++index;
        }
        return topLevelRanges;
    }

    private ArrayList<String> topLevel(ArrayList<Range> topLevelRanges, int defaultRadix) throws ExpressionEvaluatorException {
        ArrayList<String> topLevel = new ArrayList<String>(topLevelRanges.size());
        for (int i = 0; i < topLevelRanges.size(); ++i) {
            Range range = topLevelRanges.get(i);
            if (range.start == range.end) {
                int location = range.start;
                if (this.isOperator(this._al.get(location))) {
                    topLevel.add(this._al.get(location));
                    continue;
                }
                topLevel.add("" + this.evaluateToken(this._al.get(location), defaultRadix));
                continue;
            }
            topLevel.add("" + this.calculate(range.start, range.end, defaultRadix));
        }
        return topLevel;
    }

    private long calculateTopLevel(ArrayList<String> topLevel) throws ExpressionEvaluatorException {
        if (topLevel.size() == 1) {
            return this.evaluateToken(topLevel.get(0), 10);
        }
        topLevel = this.evaluateWithUnaryOperator(topLevel);
        for (int i = 0; i < _BINARY_OPERATORS_IN_PRECEDENCE.length; ++i) {
            String sTargetBinaryOperators = _BINARY_OPERATORS_IN_PRECEDENCE[i];
            topLevel = this.evaluateWithBinaryOperator(topLevel, sTargetBinaryOperators);
        }
        return this.evaluateToken(topLevel.get(0), 10);
    }

    private long evaluateToken(String token, int defaultRadix) {
        if (this.startsWithCaseInsensitively(token, _HEXADECIMAL_INDICATOR.toLowerCase())) {
            return this.stripPrefixParseLong(token, 16, _HEXADECIMAL_INDICATOR);
        }
        if (this.startsWithCaseInsensitively(token, _BINARY_INDICATOR.toLowerCase())) {
            return this.stripPrefixParseLong(token, 2, _BINARY_INDICATOR);
        }
        if (this.startsWithCaseInsensitively(token, _DECIMAL_INDICATOR.toLowerCase())) {
            return this.stripPrefixParseLong(token, 10, _DECIMAL_INDICATOR);
        }
        return Long.parseLong(token, defaultRadix);
    }

    private long stripPrefixParseLong(String token, int radix, String prefix) {
        while (this.startsWithCaseInsensitively(token, prefix)) {
            token = token.substring(prefix.length());
        }
        return Long.parseLong(token, radix);
    }

    private boolean startsWithCaseInsensitively(String s, String head) {
        return s.length() >= head.length() && s.substring(0, head.length()).equalsIgnoreCase(head);
    }

    private ArrayList<String> evaluateWithUnaryOperator(ArrayList<String> al) throws ExpressionEvaluatorException {
        String first = al.get(0);
        if (!this.isUnaryOperator(first)) {
            return al;
        }
        al.remove(0);
        String operand = al.remove(0);
        String result = this.unaryCalculate(first, operand);
        al.add(0, result);
        return al;
    }

    private ArrayList<String> evaluateWithBinaryOperator(ArrayList<String> al, String sTargetBinaryOperators) throws ExpressionEvaluatorException {
        String operator = null;
        String right = null;
        String result = null;
        String left = al.get(0);
        int startIndex = 0;
        if (this.isUnaryOperator(left)) {
            startIndex = 1;
        }
        while (startIndex < al.size() - 1) {
            left = al.get(startIndex);
            operator = al.get(startIndex + 1);
            if (sTargetBinaryOperators.indexOf(operator) < 0) {
                startIndex += 2;
                left = null;
                continue;
            }
            right = al.get(startIndex + 2);
            result = "" + this.binaryCalculate(left, operator, right);
            al.remove(startIndex);
            al.remove(startIndex);
            al.remove(startIndex);
            al.add(startIndex, result);
        }
        return al;
    }

    private long binaryCalculate(String left, String operator, String right) throws ExpressionEvaluatorException {
        char c = operator.charAt(0);
        if (c == '+') {
            return Long.parseLong(left) + Long.parseLong(right);
        }
        if (c == '-') {
            return Long.parseLong(left) - Long.parseLong(right);
        }
        if (c == '*') {
            return Long.parseLong(left) * Long.parseLong(right);
        }
        if (c == '/') {
            return Long.parseLong(left) / Long.parseLong(right);
        }
        if (c == '%') {
            return Long.parseLong(left) % Long.parseLong(right);
        }
        throw new ExpressionEvaluatorException("unsupported binary operator:" + operator);
    }

    private String unaryCalculate(String unary, String operand) throws ExpressionEvaluatorException {
        if (unary.charAt(0) == '+') {
            return operand;
        }
        if (unary.charAt(0) == '-') {
            return "" + -1L * Long.parseLong(operand);
        }
        throw new ExpressionEvaluatorException("Unrecognized unary operator: " + unary);
    }

    private int findRightParenthesisIndex(int startIndex, int endIndex) throws ExpressionEvaluatorException {
        int count = 0;
        for (int i = startIndex; i <= endIndex; ++i) {
            String s = this._al.get(i);
            if (this.isLeftParenthesis(s)) {
                --count;
            }
            if (this.isRightParenthesis(s)) {
                ++count;
            }
            if (count != 1) continue;
            return i;
        }
        throw new ExpressionEvaluatorException("Mis-matched parentheses.");
    }

    private ArrayList<String> format(String[] as) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < as.length; ++i) {
            al.addAll(this.format(as[i]));
        }
        return al;
    }

    private ArrayList<String> format(ArrayList<String> al) {
        ArrayList<String> alReturn = new ArrayList<String>();
        for (int i = 0; i < al.size(); ++i) {
            alReturn.addAll(this.format(al.get(i)));
        }
        return alReturn;
    }

    private ArrayList<String> format(String s) {
        ArrayList<String> al = new ArrayList<String>();
        StringBuffer sbTemp = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (this.isParenthesis(c) || this.isOperator(c)) {
                if (sbTemp.length() > 0) {
                    al.add(sbTemp.toString());
                }
                al.add("" + c);
                sbTemp = new StringBuffer();
                continue;
            }
            sbTemp.append(c);
        }
        if (sbTemp.length() > 0) {
            al.add(sbTemp.toString());
        }
        return al;
    }

    private boolean isOperator(String s) {
        return s.length() == 1 && this.isOperator(s.charAt(0));
    }

    private boolean isOperator(char c) {
        return this.isBinaryOperator(c) || this.isUnaryOperator(c);
    }

    private boolean isBinaryOperator(char c) {
        for (int i = 0; i < _BINARY_OPERATORS_IN_PRECEDENCE.length; ++i) {
            if (_BINARY_OPERATORS_IN_PRECEDENCE[i].indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isUnaryOperator(String s) {
        return s.length() == 1 && this.isUnaryOperator(s.charAt(0));
    }

    private boolean isUnaryOperator(char c) {
        return _UNARY_OPERATORS.indexOf(c) >= 0;
    }

    private boolean isParenthesis(char c) {
        return this.isLeftParenthesis(c) || this.isRightParenthesis(c);
    }

    private boolean isLeftParenthesis(String s) {
        return s.length() == 1 && this.isLeftParenthesis(s.charAt(0));
    }

    private boolean isLeftParenthesis(char c) {
        return _LEFT_PARENTHESES.indexOf(c) >= 0;
    }

    private boolean isRightParenthesis(String s) {
        return s.length() == 1 && this.isRightParenthesis(s.charAt(0));
    }

    private boolean isRightParenthesis(char c) {
        return _RIGHT_PARENTHESES.indexOf(c) >= 0;
    }

    private class Range {
        public int start;
        public int end;

        public Range(int startIndex, int endIndex) {
            this.start = startIndex;
            this.end = endIndex;
        }
    }
}

