/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.BitStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;

public final class CompressedRecordArray
implements Serializable {
    private int blockSizeLog2;
    private int blockSize;
    private int recordSize;
    private int index;
    private int[] bitStreamIndex = new int[16];
    private int[][] currentBlock;
    private int currentBlockIndex;
    private BitStream bits = new BitStream();
    private boolean[][] isNegative;
    private int[] lastValue;
    private int[] maxDelta;
    private boolean[] allSameDelta;
    private boolean[] allPositive;
    private byte[] encoding;
    private boolean closed = false;
    private int numRecords;
    private static final int GOLOMB2 = 0;
    private static final int GOLOMB7 = 1;
    private static final int GOLOMB8 = 2;
    private static final int VARIABLE_BYTE = 3;
    private static int numGolomb2;
    private static int numGolomb7;
    private static int numGolomb8;
    private static int numVariableByte;
    private static int numAllSameDelta;
    private static int numNotAllSameDelta;
    private static int numNegative;
    private static int numAllPositive;

    public CompressedRecordArray(int blockSizeLog2, int recordSize) {
        this.blockSizeLog2 = blockSizeLog2;
        this.blockSize = 1 << blockSizeLog2;
        this.recordSize = recordSize;
        this.currentBlock = new int[this.blockSize][recordSize];
        this.isNegative = new boolean[this.blockSize][recordSize];
        this.lastValue = new int[recordSize];
        this.maxDelta = new int[recordSize];
        this.allSameDelta = new boolean[recordSize];
        this.allPositive = new boolean[recordSize];
        this.encoding = new byte[recordSize];
    }

    public void add(int[] record) {
        assert (!this.closed);
        for (int i = 0; i < this.recordSize; ++i) {
            this.currentBlock[this.currentBlockIndex][i] = record[i];
        }
        if (++this.currentBlockIndex == this.blockSize) {
            this.flushCurrentBlock();
            this.currentBlockIndex = 0;
        }
        ++this.numRecords;
    }

    public void close() {
        this.flushCurrentBlock();
        this.bits.rewind();
        this.closed = true;
    }

    private void flushCurrentBlock() {
        this.bitStreamIndex[this.index++] = this.bits.getIndex();
        if (this.index == this.bitStreamIndex.length) {
            int[] tmp = new int[this.index * 2];
            System.arraycopy(this.bitStreamIndex, 0, tmp, 0, this.index);
            this.bitStreamIndex = tmp;
        }
        this.compressBlock();
        this.bits.nextWord();
    }

    private void compressBlock() {
        int recordIndex;
        for (recordIndex = 0; recordIndex < this.recordSize; ++recordIndex) {
            this.lastValue[recordIndex] = this.currentBlock[0][recordIndex];
            this.maxDelta[recordIndex] = 0;
            this.allSameDelta[recordIndex] = true;
            this.allPositive[recordIndex] = true;
            int lastDelta = 0;
            for (int blockIndex = 1; blockIndex < this.currentBlockIndex; ++blockIndex) {
                int delta = this.currentBlock[blockIndex][recordIndex] - this.lastValue[recordIndex];
                if (delta < 0) {
                    this.isNegative[blockIndex][recordIndex] = true;
                    delta = -delta;
                    this.allPositive[recordIndex] = false;
                    ++numNegative;
                } else {
                    this.isNegative[blockIndex][recordIndex] = false;
                }
                if (delta > this.maxDelta[recordIndex]) {
                    this.maxDelta[recordIndex] = delta;
                }
                if (blockIndex > 1 && delta != lastDelta) {
                    this.allSameDelta[recordIndex] = false;
                    ++numNotAllSameDelta;
                }
                this.lastValue[recordIndex] = this.currentBlock[blockIndex][recordIndex];
                lastDelta = delta;
                this.currentBlock[blockIndex][recordIndex] = delta;
            }
            if (this.allPositive[recordIndex]) {
                ++numAllPositive;
            }
            if (!this.allSameDelta[recordIndex]) continue;
            ++numAllSameDelta;
        }
        for (recordIndex = 0; recordIndex < this.recordSize; ++recordIndex) {
            this.bits.writeIntBits(this.allPositive[recordIndex] ? 1 : 0, 1);
            this.bits.writeIntBits(this.allSameDelta[recordIndex] ? 1 : 0, 1);
            if (this.maxDelta[recordIndex] < 24) {
                this.encoding[recordIndex] = 0;
                ++numGolomb2;
            } else if (this.maxDelta[recordIndex] < 384) {
                this.encoding[recordIndex] = 1;
                ++numGolomb7;
            } else if (this.maxDelta[recordIndex] < 2048) {
                this.encoding[recordIndex] = 2;
                ++numGolomb8;
            } else {
                this.encoding[recordIndex] = 3;
                ++numVariableByte;
            }
            this.bits.writeIntBits(this.encoding[recordIndex], 2);
        }
        for (int blockIndex = 0; blockIndex < this.currentBlockIndex; ++blockIndex) {
            block10: for (int recordIndex2 = 0; recordIndex2 < this.recordSize; ++recordIndex2) {
                if (blockIndex == 0) {
                    this.bits.writeVariableByte(this.currentBlock[blockIndex][recordIndex2]);
                    continue;
                }
                if (blockIndex != 1 && this.allSameDelta[recordIndex2]) continue;
                if (!this.allPositive[recordIndex2]) {
                    this.bits.writeIntBits(this.isNegative[blockIndex][recordIndex2] ? 1 : 0, 1);
                }
                switch (this.encoding[recordIndex2]) {
                    case 0: {
                        this.bits.writeGolombRice(this.currentBlock[blockIndex][recordIndex2], 2);
                        continue block10;
                    }
                    case 1: {
                        this.bits.writeGolombRice(this.currentBlock[blockIndex][recordIndex2], 7);
                        continue block10;
                    }
                    case 2: {
                        this.bits.writeGolombRice(this.currentBlock[blockIndex][recordIndex2], 8);
                        continue block10;
                    }
                    case 3: {
                        this.bits.writeVariableByte(this.currentBlock[blockIndex][recordIndex2]);
                    }
                }
            }
        }
    }

    public void get(int recordNumber, int[] record) {
        assert (this.closed);
        assert (recordNumber < this.numRecords);
        this.index = recordNumber >> this.blockSizeLog2;
        this.bits.setIndex(this.bitStreamIndex[this.index]);
        int desiredBlockIndex = recordNumber & this.blockSize - 1;
        for (int recordIndex = 0; recordIndex < this.recordSize; ++recordIndex) {
            this.allPositive[recordIndex] = this.bits.readIntBits(1) == 1;
            this.allSameDelta[recordIndex] = this.bits.readIntBits(1) == 1;
            this.encoding[recordIndex] = (byte)this.bits.readIntBits(2);
        }
        for (int blockIndex = 0; blockIndex <= desiredBlockIndex; ++blockIndex) {
            for (int recordIndex = 0; recordIndex < this.recordSize; ++recordIndex) {
                if (blockIndex == 0) {
                    this.currentBlock[blockIndex][recordIndex] = this.bits.readVariableByte();
                    continue;
                }
                if (blockIndex == 1 || !this.allSameDelta[recordIndex]) {
                    int delta = 0;
                    boolean isNegative = false;
                    if (!this.allPositive[recordIndex]) {
                        isNegative = this.bits.readIntBits(1) == 1;
                    }
                    switch (this.encoding[recordIndex]) {
                        case 0: {
                            delta = this.bits.readGolombRice(2);
                            break;
                        }
                        case 1: {
                            delta = this.bits.readGolombRice(7);
                            break;
                        }
                        case 2: {
                            delta = this.bits.readGolombRice(8);
                            break;
                        }
                        case 3: {
                            delta = this.bits.readVariableByte();
                        }
                    }
                    if (isNegative) {
                        delta = -delta;
                    }
                    this.currentBlock[blockIndex][recordIndex] = this.currentBlock[blockIndex - 1][recordIndex] + delta;
                    this.lastValue[recordIndex] = delta;
                    continue;
                }
                this.currentBlock[blockIndex][recordIndex] = this.currentBlock[blockIndex - 1][recordIndex] + this.lastValue[recordIndex];
            }
        }
        for (int i = 0; i < this.recordSize; ++i) {
            record[i] = this.currentBlock[desiredBlockIndex][i];
        }
    }

    public int memoryUsage() {
        return this.bits.memoryUsage() + this.bitStreamIndex.length * 4 + this.blockSize * this.recordSize * 4 * 2 + this.recordSize * 11;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            CompressedRecordArray.fpostest(args[0]);
            return;
        }
        for (int blockSizeLog2 = 0; blockSizeLog2 < 10; ++blockSizeLog2) {
            int blockSize = 1 << blockSizeLog2;
            for (int recordSize = 1; recordSize < 20; ++recordSize) {
                int value;
                int j;
                int i;
                System.out.println("doing blockSize " + blockSize + " recordSize " + recordSize);
                CompressedRecordArray ra = new CompressedRecordArray(blockSizeLog2, recordSize);
                int[] record = new int[recordSize];
                for (i = 0; i < blockSize * 10 + recordSize; ++i) {
                    for (j = 0; j < recordSize; ++j) {
                        value = i * i * j;
                        if (recordSize % 3 == 0 && j % 3 == 0) {
                            value = i * blockSize * recordSize;
                        } else if (j % 5 == 0) {
                            value = -value;
                        }
                        record[j] = value;
                    }
                    ra.add(record);
                }
                ra.close();
                for (i = 0; i < blockSize * 10 + recordSize; ++i) {
                    ra.get(i, record);
                    for (j = 0; j < recordSize; ++j) {
                        value = i * i * j;
                        if (recordSize % 3 == 0 && j % 3 == 0) {
                            value = i * blockSize * recordSize;
                        } else if (j % 5 == 0) {
                            value = -value;
                        }
                        if (record[j] == value) continue;
                        throw new Error("found " + record[j] + " expected " + value);
                    }
                }
            }
        }
        System.out.println("numGolomb2 = " + numGolomb2);
        System.out.println("numGolomb7 = " + numGolomb7);
        System.out.println("numGolomb8 = " + numGolomb8);
        System.out.println("numVariableByte = " + numVariableByte);
        System.out.println("numAllSameDelta = " + numAllSameDelta);
        System.out.println("numNotAllSameDelta = " + numNotAllSameDelta);
        System.out.println("numNegative = " + numNegative);
        System.out.println("numAllPositive = " + numAllPositive);
    }

    private static void fpostest(String filename) throws Exception {
        File file = new File(filename);
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        dis.readFully(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        dis = new DataInputStream(bais);
        int[] record = new int[8];
        for (int blockSizeLog2 = 0; blockSizeLog2 < 10; ++blockSizeLog2) {
            int i;
            dis.reset();
            long then = System.currentTimeMillis();
            CompressedRecordArray ra = new CompressedRecordArray(blockSizeLog2, 8);
            boolean eof = false;
            int r = 0;
            while (true) {
                for (i = 0; i < 8; ++i) {
                    try {
                        record[i] = dis.readInt();
                        continue;
                    }
                    catch (EOFException e) {
                        eof = true;
                        break;
                    }
                }
                if (eof) break;
                ra.add(record);
                ++r;
            }
            ra.close();
            dis.reset();
            eof = false;
            r = 0;
            while (true) {
                for (i = 0; i < 8; ++i) {
                    try {
                        int n = dis.readInt();
                        if (i == 0) {
                            ra.get(r, record);
                        }
                        if (record[i] == n) continue;
                        throw new Error("data mismatch!");
                    }
                    catch (EOFException e) {
                        eof = true;
                        break;
                    }
                }
                if (eof) break;
                ++r;
            }
            long now = System.currentTimeMillis();
            System.out.println("block size " + (1 << blockSizeLog2) + " uses " + ra.memoryUsage() + " took " + (now - then) + " ms");
        }
    }
}

