/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferedMemorySource
extends ProtectedMemoryRange
implements IMemorySource {
    private final ByteBuffer source;

    public BufferedMemorySource(long address, ByteBuffer source) {
        super(address, source.capacity());
        this.source = source;
    }

    public int getUnsignedShort(long address) throws MemoryFault {
        return this.getShort(address) & 0xFFFF;
    }

    public short getShort(long address) throws MemoryFault {
        return this.source.getShort(this.checkIndex(address, 2));
    }

    public int getInt(long address) throws MemoryFault {
        return this.source.getInt(this.checkIndex(address, 4));
    }

    public double getDouble(long address) throws MemoryFault {
        return this.source.getDouble(this.checkIndex(address, 8));
    }

    public long getLong(long address) throws MemoryFault {
        return this.source.getLong(this.checkIndex(address, 8));
    }

    public byte getByte(long address) throws MemoryFault {
        return this.source.get(this.checkIndex(address, 1));
    }

    @Override
    public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
        int index = this.checkIndex(address, length);
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = this.source.get(index + i);
        }
        return length;
    }

    private int checkIndex(long address, int byteCount) throws MemoryFault {
        if (byteCount < 0) {
            throw new IllegalArgumentException();
        }
        long maxAddress = this.baseAddress + Math.min(this.getSize(), Integer.MAX_VALUE) - (long)byteCount;
        if (address < this.baseAddress || address > maxAddress) {
            throw new MemoryFault(address);
        }
        return (int)(address - this.baseAddress);
    }

    public ByteOrder getByteOrder() {
        return this.source.order();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int getAddressSpaceId() {
        return 0;
    }
}

