/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;

public final class TraceRecordInternal
extends TraceRecord {
    private int lastEntry;

    protected TraceRecordInternal(TraceFile traceFile, long start) throws IOException {
        super(traceFile, start);
    }

    protected final void prime() throws IOException {
        this.buffer = new byte[this.bufferSize - this.headerSize];
        byte longEntryID = 0;
        int longEntryLength = 0;
        boolean newestEntry = true;
        boolean checkEntries = false;
        long lastTime = Long.MAX_VALUE;
        if ((long)this.bufferSize - this.nextEntry > 1L) {
            this.traceFile.seek(this.start + this.nextEntry + 1L);
            this.traceFile.read(this.buffer, 0, this.bufferSize - (int)this.nextEntry - 1);
        }
        this.traceFile.seek(this.start + (long)this.headerSize);
        this.traceFile.read(this.buffer, this.bufferSize - (int)this.nextEntry - 1, (int)this.nextEntry - this.headerSize + 1);
        int entry = this.bufferSize - this.headerSize - 1;
        Util.Debug.println("TraceBuffer: reading buffer size=:        " + (this.bufferSize - this.headerSize));
        Util.Debug.println("TraceBuffer: nextEntry        :           " + (int)this.nextEntry);
        Util.Debug.println("TraceBuffer: buffer[nextEntry]:           " + this.buffer[entry]);
        Util.Debug.println("TraceBuffer: File offset:                 " + this.start);
        int entryLength = Util.constructUnsignedByte(this.buffer, entry);
        int temp = 0;
        while (true) {
            if ((entry -= entryLength) < 0) {
                entry += entryLength;
                break;
            }
            if (entryLength == 8 && this.buffer[entry + 3] == 0 && this.buffer[entry + 2] == 0 && this.buffer[entry + 1] == 0) {
                this.wrapTimes.push(this.upperWord);
                this.upperWord = Util.constructUnsignedLong(this.buffer, entry + 4, 4);
                Util.Debug.println("TraceBuffer: timewrap entry=" + entry + " upperWord=" + this.upperWord);
                lastTime = Long.MAX_VALUE;
            }
            if (entryLength == 4 && this.buffer[entry + 2] == 0 && this.buffer[entry + 1] == 0) {
                Util.Debug.println("Entry with data length>256");
                longEntryID = this.buffer[entry + 3];
                longEntryLength = Util.constructUnsignedByte(this.buffer, entry);
                if (entry - (longEntryLength + longEntryID * 256) < 0) {
                    Util.Debug.println("entry < 0 must be a partial entry");
                    entry += entryLength;
                    break;
                }
                this.longEntryTraceIDs.push(new Integer(Util.constructTraceID(this.buffer, (entry -= longEntryLength + longEntryID * 256) + 1)));
                this.buffer[entry + 1] = 0;
                this.buffer[entry + 2] = 0;
                this.buffer[entry + 3] = longEntryID;
                entryLength = longEntryLength;
            }
            if (newestEntry) {
                long lowerWord = Util.constructUnsignedLong(this.buffer, entry + 4, 4).longValue();
                if (lowerWord != this.timeStamp.and(BigInteger.valueOf(0xFFFFFFFFL)).longValue()) {
                    checkEntries = true;
                    Util.Debug.println("Possible damage to first trace entry");
                    Util.Debug.println("Trace time = " + lowerWord + " header = " + this.timeStamp.and(BigInteger.valueOf(0xFFFFFFFFL)).longValue());
                }
                newestEntry = false;
            }
            if (checkEntries) {
                int traceId = Util.constructTraceID(this.buffer, entry + 1);
                long lowerWord = Util.constructUnsignedLong(this.buffer, entry + 4, 4).longValue();
                if (traceId > 256) {
                    if (lowerWord > lastTime) {
                        Util.Debug.println("Bad trace timeStamp :" + lowerWord);
                        Util.Debug.println("Ignoring " + (entry + entryLength) + "bytes of the buffer");
                        entry += entryLength;
                        break;
                    }
                    lastTime = lowerWord;
                }
            }
            if (entryLength == 0) {
                if (longEntryID == 0) {
                    Util.Debug.println("TraceRecord: Hit 0 length entry");
                    break;
                }
                Util.Debug.println("TraceRecord: 0 length entry (long record length is exact multiple of 256)");
            }
            temp = Util.constructUnsignedByte(this.buffer, entry);
            this.buffer[entry] = (byte)entryLength;
            entryLength = temp;
        }
        this.offset = entry;
        this.currentTimeStamp = this.upperWord.shiftLeft(32).or(Util.constructUnsignedLong(this.buffer, entry + 4, 4));
    }

    protected final int getNextEntry() throws IOException {
        int rc;
        if (this.notFormatted) {
            return 1;
        }
        this.notFormatted = true;
        do {
            if (this.offset >= this.bufferSize - this.headerSize - 1) {
                rc = 0;
                continue;
            }
            rc = this.processNextEntryHeader(this.buffer, this.offset);
            if (this.currentLength >= 256) {
                this.offset += 4;
            }
            this.offset += this.currentLength;
        } while (rc == 2);
        return rc;
    }
}

