/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxSourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class LocalJMXConnectionDataImpl
extends ConnectionDataImpl {
    private static final String MBEAN_OBJECT_NAME = "IBM:type=HCMBeanServer";
    private static final Logger TRACE = LogFactory.getTrace(LocalJMXConnectionDataImpl.class);

    protected LocalJMXConnectionDataImpl(String string) {
        super(string);
    }

    public LocalJMXConnectionDataImpl() {
        super("JMX");
        this.isConnectionAlive = true;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.JMX;
    }

    @Override
    public boolean spawnSources(Marshaller marshaller) {
        ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
        if (arrayList != null && !arrayList.isEmpty()) {
            Object object;
            MBeanServer mBeanServer = arrayList.get(0);
            HealthCenterMBean healthCenterMBean = null;
            try {
                ObjectName objectName = new ObjectName(MBEAN_OBJECT_NAME);
                healthCenterMBean = MBeanServerInvocationHandler.newProxyInstance(mBeanServer, objectName, HealthCenterMBean.class, true);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                TRACE.warning(malformedObjectNameException.toString());
            }
            catch (NullPointerException nullPointerException) {
                TRACE.warning(nullPointerException.toString());
            }
            if (healthCenterMBean == null) {
                return false;
            }
            int n = healthCenterMBean.startSession();
            List<Map<String, String>> list = healthCenterMBean.getLiveSourceDetails();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    object = new JmxSourceImpl(healthCenterMBean, i, n, this, list, marshaller);
                    marshaller.addSource((Source)object);
                    marshaller.addSource(((JmxSourceImpl)object).spawnConfigurationSource());
                }
            }
            String string = Messages.getString("AgentConnection.connected.to");
            object = MessageFormat.format(string, this.getDetails());
            StatusManager.setSources((String)object);
            return true;
        }
        return false;
    }

    @Override
    public void destroyConnection() {
        this.isConnectionAlive = false;
    }
}

