/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.events.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.events.parser.EventLabels;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Logger;

public abstract class EventParser
implements LineParser {
    private static final String CLASSNAME = EventParser.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(EventParser.class);
    protected AxisPair numberAxisPair = null;
    static final String COMMA = ",";
    static final String QUOTE = "\"";
    static final String EMPTY_STRING = "";
    static final String COLON = ":";

    protected abstract String getEventLabel();

    protected abstract String[] getEventTags();

    public abstract void addDataPoint(String[] var1, DataBuilder var2);

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "parse");
        if (this.numberAxisPair == null) {
            XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            YDataAxis yDataAxis = AxisUtil.prepareTimeAxis(outputProperties);
            this.numberAxisPair = DataFactory.getFactory().createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.parseEventData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        TRACE.exiting(CLASSNAME, "parse");
        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
    }

    private boolean parseEventData(DataBuilder dataBuilder, String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (!string.startsWith(this.getEventLabel())) continue;
            String string2 = string.substring(this.getEventLabel().length() + 2, string.length() - 1);
            String[] stringArray2 = string2.split(COMMA);
            SubsystemDataBuilder subsystemDataBuilder = this.getEventSubsystemData(dataBuilder);
            this.createEventDataPoint(subsystemDataBuilder, stringArray2);
            bl = true;
        }
        return bl;
    }

    protected String getValue(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.startsWith(QUOTE + string)) continue;
            return string2.substring(string.length() + 3);
        }
        return EMPTY_STRING;
    }

    protected String getString(String[] stringArray, String string) {
        String string2 = this.getValue(stringArray, string);
        return string2.substring(1, string2.length() - 1);
    }

    protected double getDouble(String[] stringArray, String string) {
        String string2 = this.getValue(stringArray, string);
        return Double.parseDouble(string2);
    }

    private void createEventDataPoint(DataBuilder dataBuilder, String[] stringArray) {
        String string = this.getEventLabel();
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        this.addDataPoint(stringArray, dataBuilder2);
    }

    protected SubsystemDataBuilder getEventSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EventLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createEventSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createEventSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = DataFactory.getFactory().createSubsystemData(EventLabels.DATA_LABEL, "com.ibm.java.diagnostics.healthcenter.events.perspective.EventsPerspective");
        return subsystemDataBuilder;
    }
}

