/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Recommendations;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterData;
import javax.management.NotificationBroadcasterSupport;

public abstract class HealthCenterDataImpl
extends NotificationBroadcasterSupport
implements HealthCenterData {
    private Data jvmData;
    protected long DEFAULT_NOTIFICATION = 2000L;
    protected int UNSET = -1;

    protected abstract String getSubsystemLabel();

    protected abstract String getRecommendationLabel();

    public HealthCenterDataImpl(Data data) {
        this.jvmData = data;
    }

    @Override
    public String[] getAllRecommendations() {
        return this.findAllRecommendations(this.getSubsystemLabel(), this.getRecommendationLabel());
    }

    @Override
    public String[] getCriticalRecommendations() {
        return this.findRecommendations(this.getSubsystemLabel(), this.getRecommendationLabel(), Status.PROBLEM);
    }

    @Override
    public String[] getHealthyRecommendations() {
        return this.findRecommendations(this.getSubsystemLabel(), this.getRecommendationLabel(), Status.HEALTHY);
    }

    @Override
    public String[] getInformationalRecommendations() {
        return this.findRecommendations(this.getSubsystemLabel(), this.getRecommendationLabel(), Status.INFORMATION);
    }

    @Override
    public String[] getWarningRecommendations() {
        return this.findRecommendations(this.getSubsystemLabel(), this.getRecommendationLabel(), Status.WARNING);
    }

    protected String[] findAllRecommendations(String string, String string2) {
        Recommendations recommendations;
        String[] stringArray = new String[]{};
        int n = 0;
        if (this.jvmData != null && (recommendations = (Recommendations)this.jvmData.getData(string2)) != null) {
            stringArray = new String[recommendations.getAllRecommendations().size()];
            for (StringData stringData : recommendations.getAllRecommendations()) {
                if (stringData.getValue() == null) continue;
                stringArray[n] = stringData.getValue();
                ++n;
            }
        }
        return stringArray;
    }

    protected String[] findRecommendations(String string, String string2, Status status) {
        Recommendations recommendations;
        String[] stringArray = new String[]{};
        if (this.jvmData != null && (recommendations = (Recommendations)this.jvmData.getData(string2)) != null) {
            stringArray = recommendations.getRecommendations(status);
        }
        return stringArray;
    }

    protected DataPointBuilder[] getEventData(Data data, String string) {
        TwoDimensionalData twoDimensionalData;
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (twoDimensionalData = (TwoDimensionalData)data.getData(string)) != null) {
            dataPointBuilderArray = twoDimensionalData.getDataPoints();
        }
        return dataPointBuilderArray;
    }

    protected long convertSummaryToLong(String string) {
        long l = this.UNSET;
        if (string != null) {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length > 1 && stringArray[1] != null) {
                double d = this.UNSET;
                try {
                    d = new Double(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String string2 = stringArray[1];
                if (string2.equalsIgnoreCase("KB")) {
                    l = (long)d * 1024L;
                } else if (string2.equalsIgnoreCase("MB")) {
                    l = (long)d * 1024L * 1024L;
                } else if (string2.equalsIgnoreCase("sec")) {
                    l *= 1000L;
                }
            } else {
                try {
                    l = new Long(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    protected double convertSummaryToDouble(String string) {
        double d = this.UNSET;
        if (string != null) {
            String[] stringArray = string.split("\\s+");
            try {
                d = new Double(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            if (stringArray.length > 1 && stringArray[1] != null) {
                String string2 = stringArray[1];
                if (string2.equalsIgnoreCase("KB")) {
                    d *= 1024.0;
                } else if (string2.equalsIgnoreCase("sec")) {
                    d *= 1000.0;
                }
            }
        }
        return d;
    }

    protected int convertSummaryToInt(String string) {
        int n = this.UNSET;
        if (string != null) {
            String[] stringArray = string.split("\\s+");
            try {
                n = new Integer(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (stringArray.length > 1 && stringArray[1] != null) {
                String string2 = stringArray[1];
                if (string2.equalsIgnoreCase("KB")) {
                    n *= 1024;
                } else if (string2.equalsIgnoreCase("sec")) {
                    n *= 1000;
                }
            }
        }
        return n;
    }

    protected double stripPercentSymbol(String string) {
        double d = this.UNSET;
        if (string != null) {
            String string2 = string;
            string2 = string2.trim();
            string2 = string2.substring(0, string2.length() - 1);
            d = new Double(string2);
        }
        return d;
    }

    protected double extractRate(String string) {
        double d = this.UNSET;
        if (string != null) {
            String[] stringArray = string.split(" ");
            d = new Double(stringArray[0]);
        }
        return d;
    }

    protected Data getJvmData() {
        return this.jvmData;
    }

    protected void setJvmData(Data data) {
        this.jvmData = data;
    }

    public double getMaxData(String string, String string2) {
        DataPointBuilder dataPointBuilder;
        Data data;
        double d = -1.0;
        Data data2 = this.getJvmData().getTopLevelData(string);
        if (data2 != null && (data = data2.getData(string2)) instanceof TwoDimensionalDataBuilder && (dataPointBuilder = ((TwoDimensionalDataBuilder)data).getMaxY()) != null) {
            d = dataPointBuilder.getRawY();
        }
        return d;
    }

    public double getMeanData(String string, String string2) {
        Data data;
        double d = -1.0;
        Data data2 = this.getJvmData().getTopLevelData(string);
        if (data2 != null && (data = data2.getData(string2)) instanceof TwoDimensionalDataBuilder) {
            d = ((TwoDimensionalDataBuilder)data).getRawMeanY();
        }
        return d;
    }

    public double getMinData(String string, String string2) {
        DataPointBuilder dataPointBuilder;
        Data data;
        double d = -1.0;
        Data data2 = this.getJvmData().getTopLevelData(string);
        if (data2 != null && (data = data2.getData(string2)) instanceof TwoDimensionalDataBuilder && (dataPointBuilder = ((TwoDimensionalDataBuilder)data).getMinY()) != null) {
            d = dataPointBuilder.getRawY();
        }
        return d;
    }
}

