/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

class IpStreamHandler
implements Runnable {
    private StringBuffer output;
    private String commandLabel;
    private InputStream input;
    private boolean isStdOut;
    private boolean tee;
    private String streamName;
    private Logger logger;

    public IpStreamHandler(StringBuffer stringBuffer, String string, InputStream inputStream, boolean bl, boolean bl2, Logger logger) {
        this.output = stringBuffer;
        this.commandLabel = string;
        this.input = inputStream;
        this.isStdOut = bl;
        this.tee = bl2;
        this.streamName = bl ? "stdout" : "stderr";
        this.logger = logger;
    }

    @Override
    public void run() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.input));
        String string = null;
        String string2 = System.getProperty("line.separator");
        try {
            while ((string = bufferedReader.readLine()) != null) {
                this.output.append(string);
                this.output.append(string2);
                if (!this.tee) continue;
                if (this.isStdOut) {
                    System.out.println(string);
                    continue;
                }
                System.err.println(string);
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.FINE, "IOException reading " + this.streamName, iOException);
        }
        this.logger.fine(this.streamName + " output for " + this.commandLabel + " command: " + string2 + this.output.toString());
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.logger.log(Level.FINE, "IOException closing BufferedReader", iOException);
        }
    }
}

