/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sequence.bytes;

import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$ByteSubSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$CompositeByteSequence$1;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$CompositeByteSequence$2;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.InputStream;

final class ByteSequenceFactory$CompositeByteSequence
implements ByteSequence {
    private static final long serialVersionUID = 2L;
    private final ByteSequence seq1;
    private final ByteSequence seq2;
    private final int len1;
    private final int len2;
    private int hc;
    private boolean hcCalculated;
    private String ts;

    ByteSequenceFactory$CompositeByteSequence(ByteSequence byteSequence, ByteSequence byteSequence2) {
        this.seq1 = byteSequence;
        this.seq2 = byteSequence2;
        this.len1 = byteSequence.length();
        this.len2 = byteSequence2.length();
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.len1 + this.len2) {
            throw new IndexOutOfBoundsException();
        }
        if (n < this.len1) {
            return this.seq1.get(n);
        }
        return this.seq2.get(n - this.len1);
    }

    public int length() {
        return this.seq1.length() + this.len2;
    }

    public ByteSequence append(ByteSequence byteSequence) throws NullPointerException {
        if (byteSequence == null) {
            throw new NullPointerException();
        }
        if (byteSequence.length() == 0) {
            return this;
        }
        return new ByteSequenceFactory$CompositeByteSequence(this, byteSequence);
    }

    public ByteSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > this.len1 + this.len2 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteSequenceFactory$ByteSubSequence(this, n, n2);
    }

    public int indexOf(byte by) {
        int n = this.seq1.indexOf(by);
        if (n == -1) {
            int n2 = this.seq2.indexOf(by);
            return n2 == -1 ? -1 : n2 + this.len1;
        }
        return n;
    }

    public int indexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.len1 + this.len2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator(n);
        while (byteSequenceIterator.hasNextByte()) {
            int n2 = byteSequenceIterator.getPosition();
            byte by2 = byteSequenceIterator.getNextByte();
            if (by2 != by) continue;
            return n2;
        }
        return -1;
    }

    public int lastIndexOf(byte by) {
        int n = this.seq2.lastIndexOf(by);
        if (n == -1) {
            return this.seq1.lastIndexOf(by);
        }
        return n + this.len1;
    }

    public int lastIndexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.len1 + this.len2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator(n);
        while (byteSequenceIterator.hasPreviousByte()) {
            byte by2 = byteSequenceIterator.getPreviousByte();
            int n2 = byteSequenceIterator.getPosition();
            if (by2 != by) continue;
            return n2;
        }
        return -1;
    }

    public boolean isEmpty() {
        return false;
    }

    public InputStream getInputStream() {
        return new ByteSequenceFactory$CompositeByteSequence$1(this);
    }

    public ByteSequenceIterator getIterator() {
        return this.getIterator(0);
    }

    public ByteSequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.len1 + this.len2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return new ByteSequenceFactory$CompositeByteSequence$2(this, n);
    }

    public String toBinaryString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.seq1.toBinaryString());
        stringBuilder.append(this.seq2.toBinaryString());
        return stringBuilder.toString();
    }

    public String toOctalString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.seq1.toOctalString());
        stringBuilder.append(this.seq2.toOctalString());
        return stringBuilder.toString();
    }

    public String toHexString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.seq1.toHexString());
        stringBuilder.append(this.seq2.toHexString());
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.ts == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            ByteSequenceIterator byteSequenceIterator = this.seq1.getIterator();
            ByteSequenceIterator byteSequenceIterator2 = this.seq2.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                stringBuilder.append(byteSequenceIterator.getNextByte());
                if (!byteSequenceIterator.hasNextByte() && !byteSequenceIterator2.hasNextByte()) continue;
                stringBuilder.append("][");
            }
            while (byteSequenceIterator2.hasNextByte()) {
                stringBuilder.append(byteSequenceIterator2.getNextByte());
                if (!byteSequenceIterator2.hasNextByte()) continue;
                stringBuilder.append("][");
            }
            stringBuilder.append("]");
            this.ts = stringBuilder.toString();
        }
        return this.ts;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ByteSequence)) {
            return false;
        }
        ByteSequence byteSequence = (ByteSequence)object;
        if (byteSequence.length() != this.len1 + this.len2) {
            return false;
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        ByteSequenceIterator byteSequenceIterator2 = byteSequence.getIterator();
        while (byteSequenceIterator.hasNextByte() && byteSequenceIterator2.hasNextByte()) {
            Byte by;
            Byte by2 = byteSequenceIterator.getNextByte();
            if (by2 == (by = Byte.valueOf(byteSequenceIterator2.getNextByte()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hcCalculated) {
            int n = 461;
            int n2 = 73;
            ByteSequenceIterator byteSequenceIterator = this.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                byte by = byteSequenceIterator.getNextByte();
                n2 = n2 * 461 + by;
            }
            this.hc = n2;
            this.hcCalculated = true;
        }
        return this.hc;
    }

    static int access$100(ByteSequenceFactory$CompositeByteSequence byteSequenceFactory$CompositeByteSequence) {
        return byteSequenceFactory$CompositeByteSequence.len1;
    }

    static int access$200(ByteSequenceFactory$CompositeByteSequence byteSequenceFactory$CompositeByteSequence) {
        return byteSequenceFactory$CompositeByteSequence.len2;
    }

    static ByteSequence access$300(ByteSequenceFactory$CompositeByteSequence byteSequenceFactory$CompositeByteSequence) {
        return byteSequenceFactory$CompositeByteSequence.seq1;
    }

    static ByteSequence access$400(ByteSequenceFactory$CompositeByteSequence byteSequenceFactory$CompositeByteSequence) {
        return byteSequenceFactory$CompositeByteSequence.seq2;
    }
}

