/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gpu;

import com.ibm.gpu.CUDAManager;
import com.ibm.gpu.GPUConfigurationException;
import com.ibm.gpu.GPUSortException;
import com.ibm.gpu.SortNetwork;
import java.util.Objects;

public class Maths {
    private static int getDefaultDevice() {
        return CUDAManager.instanceInternal().getDefaultDevice();
    }

    public static void sortArray(double[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, 0, array.length);
    }

    public static void sortArray(double[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, fromIndex, toIndex);
    }

    public static void sortArray(float[] array) throws GPUSortException, GPUConfigurationException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, 0, array.length);
    }

    public static void sortArray(float[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        Maths.sortArray(Maths.getDefaultDevice(), array, fromIndex, toIndex);
    }

    public static void sortArray(int deviceId, double[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, 0, array.length);
    }

    public static void sortArray(int deviceId, double[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, fromIndex, toIndex);
    }

    public static void sortArray(int deviceId, float[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, 0, array.length);
    }

    public static void sortArray(int deviceId, float[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, fromIndex, toIndex);
    }

    public static void sortArray(int deviceId, int[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, 0, array.length);
    }

    public static void sortArray(int deviceId, int[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, fromIndex, toIndex);
    }

    public static void sortArray(int deviceId, long[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, 0, array.length);
    }

    public static void sortArray(int deviceId, long[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(deviceId, array, fromIndex, toIndex);
    }

    public static void sortArray(int[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, 0, array.length);
    }

    public static void sortArray(int[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, fromIndex, toIndex);
    }

    public static void sortArray(long[] array) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, 0, array.length);
    }

    public static void sortArray(long[] array, int fromIndex, int toIndex) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(array);
        SortNetwork.sortArray(Maths.getDefaultDevice(), array, fromIndex, toIndex);
    }
}

