/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DSAKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = 8751667575123698655L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger y;
    private transient boolean destroyed = false;
    private transient DSAKey dsaKey = null;
    private static final String[] z;

    public DSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        byte[] byArray;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        try {
            byArray = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[5] + iOException.getMessage());
        }
        try {
            byArray = this.b();
            this.dsaKey = DSAKey.createPublicKey(iBMJCEPlusProvider.a(), byArray);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[6]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public DSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = this.b();
            this.dsaKey = DSAKey.createPublicKey(iBMJCEPlusProvider.a(), byArray2);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[4]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public DSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, DSAKey dSAKey) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = new AlgorithmId(AlgorithmId.DSA_oid, dSAKey.getParameters());
            byte[] byArray = this.a(dSAKey.getPublicKeyBytes());
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.dsaKey = dSAKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[2]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DSAParams getParams() {
        this.c();
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters != null) return algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return null;
        }
    }

    @Override
    public BigInteger getY() {
        this.c();
        return this.y;
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        return super.getEncoded();
    }

    DSAKey a() {
        return this.dsaKey;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[3], iOException);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(4);
        BigInteger bigInteger = derValueArray[0].getInteger();
        DerValue derValue = new DerValue(2, bigInteger.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] b() throws IOException {
        DSAParams dSAParams = this.getParams();
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.y.toByteArray()), new DerValue(2, dSAParams.getP().toByteArray()), new DerValue(2, dSAParams.getQ().toByteArray()), new DerValue(2, dSAParams.getG().toByteArray())};
        try (DerOutputStream derOutputStream = new DerOutputStream();){
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            return byArray;
        }
    }

    public String toString() {
        return this.provider.getName() + z[1] + this.y.toString() + "\n";
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[7]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dsaKey = null;
            this.y = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[0]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "W\u001d0R\fh\u0010 \u0001EpU7N\fo\u001a7FIqU/@@j\u0011";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                block18: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block18;
                    n5 = n5;
                    if (n5 <= n4) break block19;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 3;
                            break;
                        }
                        case 1: {
                            n6 = 117;
                            break;
                        }
                        case 2: {
                            n6 = 89;
                            break;
                        }
                        case 3: {
                            n6 = 33;
                            break;
                        }
                        default: {
                            n6 = 44;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "#1\n`\fS\u0000;ME`U\u0012DU9\u007f";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "E\u00140MIgU-N\f`\u0007<@XfU\u001drm#\u0005,C@j\u0016yJIz";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "J\u001b/@@j\u0011ye\u007fBU)TNo\u001c:\u0001Gf\f";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "E\u00140MIgU-N\f`\u0007<@XfU\u001drm#\u0005,C@j\u0016yJIz";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "`\u001a,E\fm\u001a-\u0001hF'yDB`\u001a=D\fzOy";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "E\u00140MIgU-N\f`\u0007<@XfU\u001drm#\u0005,C@j\u0016yJIz";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "G&\u0018qYa\u00190Bgf\fyJIz\u0006y@^fU7NX#\u00110SI`\u00015X\fg\u0010*D^j\u00145HVb\u00175D";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

