/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.EncryptedKey;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public final class PKIArchiveOptions
extends CMPDerObject {
    private EncryptedKey encryptedPrivKey;
    private byte[] keyGenParameters;
    private boolean archiveRemGenPrivKey;
    public static final int ENCRYPTED_PRIV_KEY = 0;
    public static final int KEY_GEN_PARAMETERS = 1;
    public static final int ARCHIVE_REM_GEN_PRIV_KEY = 2;
    private static final byte TAG_ENCRYPTED_KEY = 0;
    private static final byte TAG_KEY_GEN_PARAMETERS = 1;
    private static final byte TAG_ARCHIVE_REM_GEN_PRIV_KEY = 2;
    private int choice;

    public PKIArchiveOptions(int n, Object object) {
        this.setPKIArchiveOptions(n, object);
    }

    public PKIArchiveOptions(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new PKIArchiveOptions(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        Object var2_2 = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("PKIArchiveOptions parsing error, missing data");
        }
        this.encryptedPrivKey = null;
        this.keyGenParameters = null;
        this.archiveRemGenPrivKey = false;
        if (derValue.isContextSpecific((byte)0) && derValue.isConstructed()) {
            this.encryptedPrivKey = new EncryptedKey(derValue.getData().getDerValue().toByteArray());
            this.choice = 0;
        } else if (derValue.isContextSpecific((byte)1) && !derValue.isConstructed()) {
            derValue.resetTag((byte)4);
            this.keyGenParameters = derValue.getOctetString();
            this.choice = 1;
        } else if (derValue.isContextSpecific((byte)2) && !derValue.isConstructed()) {
            derValue.resetTag((byte)1);
            this.archiveRemGenPrivKey = derValue.getBoolean();
            this.choice = 2;
        } else {
            throw new IOException("PKIArchiveOptions parsing error, invalid tag");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("PKIArchiveOptions parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        switch (this.choice) {
            case 0: {
                if (this.encryptedPrivKey == null) {
                    throw new IOException("PKIArchiveOptions encoding error, encrypted key not specified");
                }
                this.encryptedPrivKey.encode((OutputStream)derOutputStream);
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
                break;
            }
            case 1: {
                if (this.keyGenParameters == null) {
                    throw new IOException("PKIArchiveOptions encoding error, key gen parameters not specified");
                }
                derOutputStream.putOctetString(this.keyGenParameters);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)1), derOutputStream);
                break;
            }
            case 2: {
                derOutputStream.putBoolean(this.archiveRemGenPrivKey);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)2), derOutputStream);
                break;
            }
        }
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(PKIArchiveOptions pKIArchiveOptions) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIArchiveOptions == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIArchiveOptions.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIArchiveOptions) {
            return this.equals((PKIArchiveOptions)object);
        }
        return false;
    }

    public Object getArchiveOption() {
        switch (this.choice) {
            case 0: {
                return (EncryptedKey)this.encryptedPrivKey.clone();
            }
            case 1: {
                return (byte[])this.keyGenParameters.clone();
            }
            case 2: {
                return new Boolean(this.archiveRemGenPrivKey);
            }
        }
        return null;
    }

    public int getArchiveType() {
        return this.choice;
    }

    private void setPKIArchiveOptions(int n, Object object) {
        this.choice = n;
        switch (n) {
            case 0: {
                if (object == null) {
                    throw new IllegalArgumentException("PKIArchiveOptions error, value not specified");
                }
                if (!(object instanceof EncryptedKey)) {
                    throw new IllegalArgumentException("POPOPrivKey error, invalid value");
                }
                this.encryptedPrivKey = (EncryptedKey)object;
                break;
            }
            case 1: {
                if (object == null) {
                    throw new IllegalArgumentException("PKIArchiveOptions error, value not specified");
                }
                if (!(object instanceof byte[])) {
                    throw new IllegalArgumentException("POPOPrivKey error, invalid value");
                }
                this.keyGenParameters = (byte[])object;
                break;
            }
            case 2: {
                if (object == null) {
                    throw new IllegalArgumentException("PKIArchiveOptions error, value not specified");
                }
                if (!(object instanceof Boolean)) {
                    throw new IllegalArgumentException("POPOPrivKey error, invalid value");
                }
                this.archiveRemGenPrivKey = (Boolean)object;
                break;
            }
            default: {
                throw new IllegalArgumentException("POPOPrivKey error, invalid type");
            }
        }
    }

    public String toString() {
        String string = "PKIArchiveOptions:";
        switch (this.choice) {
            case 0: {
                if (this.encryptedPrivKey == null) break;
                string = String.valueOf(string) + "\r\n\tencrypted key: " + this.encryptedPrivKey.toString();
                break;
            }
            case 1: {
                string = String.valueOf(string) + "\r\n\tkeygen parameters: " + new String(this.keyGenParameters);
                break;
            }
            default: {
                string = this.archiveRemGenPrivKey ? String.valueOf(string) + "\r\n\t Private key archival is desired" : String.valueOf(string) + "\r\n\t Private key archival is not desired";
            }
        }
        return string;
    }
}

