/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public final class CAProtEncCertInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.ca_prot_enc_cert_oid;
    private Certificate value;
    private byte[] encodedValue;

    public CAProtEncCertInfoValue(Certificate certificate) throws IOException {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("CAProtEncCertInfoValue error, invalid certificate type. Only X509 certificate is supported");
        }
        this.value = certificate;
        this.setEncodedValue();
    }

    public CAProtEncCertInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new CAProtEncCertInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        try {
            this.value = new X509CertImpl(derValue);
            this.setEncodedValue();
        }
        catch (Exception exception) {
            throw new IOException("CAProtEncCertInfoValue decoding error, " + exception.toString());
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(CAProtEncCertInfoValue cAProtEncCertInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (cAProtEncCertInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            cAProtEncCertInfoValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CAProtEncCertInfoValue) {
            return this.equals((CAProtEncCertInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "CAProtEncCert";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encodedValue);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setEncodedValue() throws IOException {
        try {
            this.encodedValue = ((X509Certificate)this.value).getEncoded();
        }
        catch (Exception exception) {
            throw new IOException("CAProtEncCertInfoValue error, " + exception);
        }
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "CAProtEncCertInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\ncertificate:\r\n";
        string = object == null ? String.valueOf(string) + "no cert" : String.valueOf(string) + object.toString();
        return string;
    }
}

