/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.compression;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.compression.WsDeflater;
import com.ibm.ws.util.objectpool.CircularObjectPool;
import com.ibm.ws.util.objectpool.ObjectFactory;

public class DeflaterPool {
    private static final TraceComponent tc = Tr.register(DeflaterPool.class, "Compression", "com.ibm.ws.compression");
    protected static int intUniqueCounter = 0;
    protected static Object oCounterSemaphore = new Object();
    private static DeflaterPool instance;
    private CircularObjectPool pool;

    private DeflaterPool(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "New DeflaterPool: poolDepth=" + n);
        }
        this.pool = new CircularObjectPool(n, new DeflaterFactory());
    }

    private static synchronized void createSingleton() {
        if (null == instance) {
            instance = new DeflaterPool(100);
        }
    }

    public static DeflaterPool getInstance() {
        if (null == instance) {
            DeflaterPool.createSingleton();
        }
        return instance;
    }

    public WsDeflater getEntry() {
        return (WsDeflater)this.pool.get();
    }

    public void release(Object object) {
        this.pool.put(object);
    }

    private class DeflaterFactory
    implements ObjectFactory {
        private DeflaterFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create() {
            int n;
            Object object = oCounterSemaphore;
            synchronized (object) {
                n = intUniqueCounter++;
            }
            return new WsDeflater(new Integer(n));
        }
    }
}

