/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptorImpl;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DescriptorType;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfigImpl;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl;
import com.ibm.gsk.ikeyman.util.FileName;
import javax.security.auth.callback.CallbackHandler;

public class DatabaseDescriptorFactory {
    public static DatabaseDescriptorFactory$DatabaseDescriptor getDatabaseDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, DatabaseDescriptorFactory$DescriptorType databaseDescriptorFactory$DescriptorType) throws KeyManagerException {
        switch (databaseDescriptorFactory$DescriptorType) {
            case Source: {
                return DatabaseDescriptorFactory.getSourceDescriptor(commandParameters, callbackHandler);
            }
            case Target: {
                return DatabaseDescriptorFactory.getTargetDescriptor(commandParameters, callbackHandler);
            }
            case Secondary: {
                return DatabaseDescriptorFactory.getSecondaryDescriptor(commandParameters, callbackHandler);
            }
        }
        return null;
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getDatabaseDescriptor(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        switch (constants$DatabaseType) {
            case CMS: {
                return DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl.getDescriptor(databaseDescriptorFactory$DatabaseDescriptor);
            }
            case PKCS12: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getDescriptor(databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType.PKCS12);
            }
            case PKCS12S2: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getDescriptor(databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType.PKCS12S2);
            }
        }
        return DatabaseDescriptorFactory$DatabaseDescriptorImpl.getDescriptor(databaseDescriptorFactory$DatabaseDescriptor, constants$DatabaseType);
    }

    private static DatabaseDescriptorFactory$DatabaseDescriptor getSecondaryDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        Constants$DatabaseType constants$DatabaseType = commandParameters.isParameterPresent(Constants$Parameter.SecondaryDbType) ? commandParameters.getSecondaryDbType() : DatabaseDescriptorFactory.deriveDatabaseType(new FileName(commandParameters.getSecondaryDb()));
        switch (constants$DatabaseType) {
            case CMS: {
                return DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl.getSecondaryDescriptor(commandParameters, callbackHandler);
            }
            case PKCS11Direct: 
            case PKCS11Config: {
                throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_OPERATION, new String[]{"PKCS11Direct db cannot be secondary"});
            }
            case PKCS12: 
            case PKCS12S2: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getSecondaryDescriptor(commandParameters, callbackHandler);
            }
        }
        return DatabaseDescriptorFactory$DatabaseDescriptorImpl.getSecondaryDescriptor(commandParameters, callbackHandler);
    }

    private static DatabaseDescriptorFactory$DatabaseDescriptor getTargetDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        Constants$DatabaseType constants$DatabaseType;
        if (commandParameters.isParameterPresent(Constants$Parameter.TargetType)) {
            constants$DatabaseType = commandParameters.getTargetType();
        } else if (commandParameters.isParameterPresent(Constants$Parameter.Target)) {
            constants$DatabaseType = DatabaseDescriptorFactory.deriveDatabaseType(new FileName(commandParameters.getTarget()));
        } else if (commandParameters.isParameterPresent(Constants$Parameter.Crypto)) {
            constants$DatabaseType = commandParameters.isParameterPresent(Constants$Parameter.RelativeSlotNumber) ? Constants$DatabaseType.PKCS11Direct : Constants$DatabaseType.PKCS11Config;
        } else {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_TARGET_DATABASE_SPECIFIED, new String[0]);
        }
        switch (constants$DatabaseType) {
            case CMS: {
                return DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl.getTargetDescriptor(commandParameters, callbackHandler);
            }
            case PKCS11Direct: {
                return DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl.getDescriptor(commandParameters, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Target);
            }
            case PKCS11Config: {
                return DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfigImpl.getDescriptor(commandParameters, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Target);
            }
            case PKCS12: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getTargetDescriptor(commandParameters, callbackHandler, Constants$DatabaseType.PKCS12);
            }
            case PKCS12S2: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getTargetDescriptor(commandParameters, callbackHandler, Constants$DatabaseType.PKCS12S2);
            }
        }
        return DatabaseDescriptorFactory$DatabaseDescriptorImpl.getTargetDescriptor(commandParameters, callbackHandler, constants$DatabaseType);
    }

    private static DatabaseDescriptorFactory$DatabaseDescriptor getSourceDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        Constants$DatabaseType constants$DatabaseType;
        if (commandParameters.isParameterPresent(Constants$Parameter.Type)) {
            constants$DatabaseType = commandParameters.getType();
        } else if (commandParameters.isParameterPresent(Constants$Parameter.OldFormat)) {
            constants$DatabaseType = commandParameters.getOldFormat();
        } else if (commandParameters.isParameterPresent(Constants$Parameter.DatabaseName)) {
            constants$DatabaseType = DatabaseDescriptorFactory.deriveDatabaseType(new FileName(commandParameters.getDatabaseName()));
        } else if (commandParameters.isParameterPresent(Constants$Parameter.Crypto)) {
            constants$DatabaseType = commandParameters.isParameterPresent(Constants$Parameter.RelativeSlotNumber) ? Constants$DatabaseType.PKCS11Direct : Constants$DatabaseType.PKCS11Config;
        } else if (commandParameters.isParameterPresent(Constants$Parameter.File)) {
            constants$DatabaseType = Constants$DatabaseType.PKCS12;
        } else {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SOURCE_DATABASE_SPECIFIED, new String[0]);
        }
        if (commandParameters.isParameterPresent(Constants$Parameter.Pfx) && commandParameters.isPfx() && constants$DatabaseType != Constants$DatabaseType.PKCS12 && constants$DatabaseType != Constants$DatabaseType.PKCS12S2) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_PFX_OPTION);
        }
        switch (constants$DatabaseType) {
            case CMS: {
                return DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl.getDescriptor(commandParameters, callbackHandler);
            }
            case PKCS11Direct: {
                return DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl.getDescriptor(commandParameters, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Source);
            }
            case PKCS11Config: {
                return DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorConfigImpl.getDescriptor(commandParameters, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Source);
            }
            case PKCS12: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getDescriptor(commandParameters, callbackHandler, Constants$DatabaseType.PKCS12);
            }
            case PKCS12S2: {
                return DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl.getDescriptor(commandParameters, callbackHandler, Constants$DatabaseType.PKCS12S2);
            }
        }
        return DatabaseDescriptorFactory$DatabaseDescriptorImpl.getDescriptor(commandParameters, callbackHandler, constants$DatabaseType);
    }

    public static Constants$DatabaseType deriveDatabaseType(FileName fileName) {
        String string = fileName.getFileExtension();
        Constants$DatabaseType constants$DatabaseType = Constants$DatabaseType.getTypeForExtension(string);
        if (constants$DatabaseType == Constants$DatabaseType.UNKNOWN) {
            return Constants$DatabaseType.getDefaultType();
        }
        return constants$DatabaseType;
    }
}

