/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.ibm.security.x509.X509CertImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import sun.security.util.Debug;

public final class UntrustedCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String ALGORITHM_KEY = "Algorithm";
    private static final Properties props = new Properties();
    private static final String algorithm;

    public static boolean isUntrusted(X509Certificate x509Certificate) {
        String string;
        if (algorithm == null) {
            return false;
        }
        if (x509Certificate instanceof X509CertImpl) {
            string = ((X509CertImpl)x509Certificate).getFingerprint(algorithm);
        } else {
            try {
                string = new X509CertImpl(x509Certificate.getEncoded()).getFingerprint(algorithm);
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        return props.containsKey(string);
    }

    private UntrustedCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block14: {
                    File file = new File(System.getProperty("java.home"), "lib/security/blacklisted.certs");
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        props.load(fileInputStream);
                    }
                    catch (IOException iOException) {
                        if (debug == null) break block14;
                        debug.println("Error parsing blacklisted.certs");
                    }
                }
                return null;
            }
        });
        algorithm = props.getProperty(ALGORITHM_KEY);
    }
}

