/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;

class ESSCertId {
    private static volatile HexDumpEncoder hexDumper;
    private byte[] certHash;
    private GeneralNames issuer;
    private SerialNumber serialNumber;

    ESSCertId(DerValue derValue) throws IOException {
        this.certHash = derValue.getData().getDerValue().toByteArray();
        if (derValue.getData().available() > 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            try {
                this.issuer = new GeneralNames(derValue2.getData().getDerValue());
            }
            catch (GeneralNamesException generalNamesException) {
                throw (IOException)new IOException().initCause(generalNamesException);
            }
            this.serialNumber = new SerialNumber(derValue2.getData().getDerValue());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n\tCertificate hash (SHA-1):\n");
        if (hexDumper == null) {
            hexDumper = new HexDumpEncoder();
        }
        stringBuffer.append(hexDumper.encode(this.certHash));
        if (this.issuer != null && this.serialNumber != null) {
            stringBuffer.append("\n\tIssuer: " + this.issuer + "\n");
            stringBuffer.append("\t" + this.serialNumber);
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

