/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.server.UID;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sun.rmi.runtime.RuntimeUtil;
import sun.security.action.GetLongAction;

public class DGCAckHandler {
    private static final long dgcAckTimeout = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.ackTimeout", 300000L));
    private static final ScheduledExecutorService scheduler = AccessController.doPrivileged(new RuntimeUtil.GetInstanceAction()).getScheduler();
    private static final Map<UID, DGCAckHandler> idTable = Collections.synchronizedMap(new HashMap());
    private final UID id;
    private List<Object> objList = new ArrayList<Object>();
    private Future<?> task = null;

    DGCAckHandler(UID uID) {
        this.id = uID;
        if (uID != null) {
            assert (!idTable.containsKey(uID));
            idTable.put(uID, this);
        }
    }

    synchronized void add(Object object) {
        if (this.objList != null) {
            this.objList.add(object);
        }
    }

    synchronized void startTimer() {
        if (this.objList != null && this.task == null) {
            this.task = scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    DGCAckHandler.received(DGCAckHandler.this.id);
                }
            }, dgcAckTimeout, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void release() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
        this.objList = null;
    }

    public static void received(UID uID) {
        DGCAckHandler dGCAckHandler = idTable.remove(uID);
        if (dGCAckHandler != null) {
            dGCAckHandler.release();
        }
    }
}

