/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Entry<?, ?>[] EMPTY_TABLE = new Entry[0];
    Entry<K, V>[] table = EMPTY_TABLE;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet;

    private Entry<K, V>[] newTable(int n) {
        return new Entry[n];
    }

    public WeakHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        for (int i = 1; i < n; i <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = n;
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap() {
        this(16, 0.75f);
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.inflateTable(this.threshold);
        this.putAll(map);
    }

    private static int roundUpToPowerOf2(int n) {
        int n2;
        n2 = n >= 0x40000000 ? 0x40000000 : ((n2 = Integer.highestOneBit(n)) != 0 ? (Integer.bitCount(n) > 1 ? n2 << 1 : n2) : 1);
        return n2;
    }

    private void inflateTable(int n) {
        int n2 = WeakHashMap.roundUpToPowerOf2(n);
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 1.0737418E9f);
        this.table = this.newTable(n2);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    final int hash(Object object) {
        int n = object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> reference;
        while ((reference = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> entry;
                Entry entry2 = (Entry)reference;
                int n = WeakHashMap.indexFor(entry2.hash, this.table.length);
                Entry<K, V> entry3 = entry = this.table[n];
                while (entry3 != null) {
                    Entry entry4 = entry3.next;
                    if (entry3 == entry2) {
                        if (entry == entry2) {
                            this.table[n] = entry4;
                        } else {
                            entry.next = entry4;
                        }
                        entry2.value = null;
                        --this.size;
                        break;
                    }
                    entry = entry3;
                    entry3 = entry4;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object object) {
        if (this.size == 0) {
            return null;
        }
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && WeakHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    Entry<K, V> getEntry(Object object) {
        if (this.size == 0) {
            return null;
        }
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (!(entry == null || entry.hash == n && WeakHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Object object = WeakHashMap.maskNull(k);
        int n = this.hash(object);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.hash && WeakHashMap.eq(object, entry.get())) {
                Object v2 = entry.value;
                if (v != v2) {
                    entry.value = v;
                }
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(object, v, this.queue, n, entry);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    void resize(int n) {
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] entryArray2 = this.newTable(n);
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            entryArray[i] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t = entry.get();
                if (t == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n = WeakHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n];
                    entryArray2[n] = entry;
                }
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable((int)Math.max((float)n * this.loadFactor, (float)this.threshold));
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry;
        if (this.size == 0) {
            return null;
        }
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.hash && WeakHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    boolean removeMapping(Object object) {
        Entry<K, V> entry;
        if (this.size == 0 || !(object instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n = this.hash(object2);
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry3 = entry = entryArray[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                return true;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set == null) {
            this.keySet = set = new KeySet();
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection == null) {
            this.values = collection = new Values();
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Entry<K, V>[] entryArray;
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        for (Entry<K, V> entry : entryArray = this.getTable()) {
            while (entry != null) {
                Object t = entry.get();
                if (t != null) {
                    biConsumer.accept(WeakHashMap.unmaskNull(t), entry.value);
                }
                entry = entry.next;
                if (n == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Entry<K, V>[] entryArray;
        Objects.requireNonNull(biFunction);
        int n = this.modCount;
        for (Entry<K, V> entry : entryArray = this.getTable()) {
            while (entry != null) {
                Object t = entry.get();
                if (t != null) {
                    entry.value = biFunction.apply(WeakHashMap.unmaskNull(t), entry.value);
                }
                entry = entry.next;
                if (n == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object object, V v, ReferenceQueue<Object> referenceQueue, int n, Entry<K, V> entry) {
            super(object, referenceQueue);
            this.value = v;
            this.hash = n;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return (K)WeakHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return Objects.hashCode(k) ^ Objects.hashCode(v);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = WeakHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return WeakHashMap.this.removeMapping(object);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new AbstractMap.SimpleEntry(entry));
            }
            return arrayList;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.deepCopy().toArray(TArray);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    static final class EntrySpliterator<K, V>
    extends WeakHashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            super(weakHashMap, n, n2, n3, n4);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                entrySpliterator = null;
            } else {
                this.index = n3;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            WeakHashMap weakHashMap = this.map;
            Entry<K, V>[] entryArray = weakHashMap.table;
            int n3 = this.fence;
            if (n3 < 0) {
                n2 = this.expectedModCount = weakHashMap.modCount;
                n3 = this.fence = entryArray.length;
            } else {
                n2 = this.expectedModCount;
            }
            if (entryArray.length >= n3 && (n = this.index) >= 0 && (n < (this.index = n3) || this.current != null)) {
                Entry entry = this.current;
                this.current = null;
                do {
                    if (entry == null) {
                        entry = entryArray[n++];
                        continue;
                    }
                    Object t = entry.get();
                    Object v = entry.value;
                    entry = entry.next;
                    if (t == null) continue;
                    Object object = WeakHashMap.unmaskNull(t);
                    consumer.accept(new AbstractMap.SimpleImmutableEntry(object, v));
                } while (entry != null || n < n3);
            }
            if (weakHashMap.modCount != n2) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n = this.getFence();
            if (entryArray.length >= n && this.index >= 0) {
                while (this.current != null || this.index < n) {
                    if (this.current == null) {
                        this.current = entryArray[this.index++];
                        continue;
                    }
                    Object t = this.current.get();
                    Object v = this.current.value;
                    this.current = this.current.next;
                    if (t == null) continue;
                    Object object = WeakHashMap.unmaskNull(t);
                    consumer.accept(new AbstractMap.SimpleImmutableEntry(object, v));
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 1;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakHashMap.this.modCount;
            this.index = WeakHashMap.this.isEmpty() ? 0 : WeakHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] entryArray = WeakHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n = this.index;
                while (entry == null && n > 0) {
                    entry = entryArray[--n];
                }
                this.entry = entry;
                this.index = n;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (WeakHashMap.this.containsKey(object)) {
                WeakHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        @Override
        public Spliterator<K> spliterator() {
            return new KeySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    static final class KeySpliterator<K, V>
    extends WeakHashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            super(weakHashMap, n, n2, n3, n4);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                keySpliterator = null;
            } else {
                this.index = n3;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            WeakHashMap weakHashMap = this.map;
            Entry<K, V>[] entryArray = weakHashMap.table;
            int n3 = this.fence;
            if (n3 < 0) {
                n2 = this.expectedModCount = weakHashMap.modCount;
                n3 = this.fence = entryArray.length;
            } else {
                n2 = this.expectedModCount;
            }
            if (entryArray.length >= n3 && (n = this.index) >= 0 && (n < (this.index = n3) || this.current != null)) {
                Entry entry = this.current;
                this.current = null;
                do {
                    if (entry == null) {
                        entry = entryArray[n++];
                        continue;
                    }
                    Object t = entry.get();
                    entry = entry.next;
                    if (t == null) continue;
                    Object object = WeakHashMap.unmaskNull(t);
                    consumer.accept(object);
                } while (entry != null || n < n3);
            }
            if (weakHashMap.modCount != n2) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n = this.getFence();
            if (entryArray.length >= n && this.index >= 0) {
                while (this.current != null || this.index < n) {
                    if (this.current == null) {
                        this.current = entryArray[this.index++];
                        continue;
                    }
                    Object t = this.current.get();
                    this.current = this.current.next;
                    if (t == null) continue;
                    Object object = WeakHashMap.unmaskNull(t);
                    consumer.accept(object);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 1;
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    static final class ValueSpliterator<K, V>
    extends WeakHashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            super(weakHashMap, n, n2, n3, n4);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                valueSpliterator = null;
            } else {
                this.index = n3;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            WeakHashMap weakHashMap = this.map;
            Entry<K, V>[] entryArray = weakHashMap.table;
            int n3 = this.fence;
            if (n3 < 0) {
                n2 = this.expectedModCount = weakHashMap.modCount;
                n3 = this.fence = entryArray.length;
            } else {
                n2 = this.expectedModCount;
            }
            if (entryArray.length >= n3 && (n = this.index) >= 0 && (n < (this.index = n3) || this.current != null)) {
                Entry entry = this.current;
                this.current = null;
                do {
                    if (entry == null) {
                        entry = entryArray[n++];
                        continue;
                    }
                    Object t = entry.get();
                    Object v = entry.value;
                    entry = entry.next;
                    if (t == null) continue;
                    consumer.accept(v);
                } while (entry != null || n < n3);
            }
            if (weakHashMap.modCount != n2) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n = this.getFence();
            if (entryArray.length >= n && this.index >= 0) {
                while (this.current != null || this.index < n) {
                    if (this.current == null) {
                        this.current = entryArray[this.index++];
                        continue;
                    }
                    Object t = this.current.get();
                    Object v = this.current.value;
                    this.current = this.current.next;
                    if (t == null) continue;
                    consumer.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    static class WeakHashMapSpliterator<K, V> {
        final WeakHashMap<K, V> map;
        Entry<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        WeakHashMapSpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            this.map = weakHashMap;
            this.index = n;
            this.fence = n2;
            this.est = n3;
            this.expectedModCount = n4;
        }

        final int getFence() {
            int n = this.fence;
            if (n < 0) {
                WeakHashMap<K, V> weakHashMap = this.map;
                this.est = weakHashMap.size();
                this.expectedModCount = weakHashMap.modCount;
                n = this.fence = weakHashMap.table.length;
            }
            return n;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }
}

