/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ResolverAnonymous
extends ResourceResolverSpi {
    private final Path resourcePath;

    public ResolverAnonymous(String string) throws IOException {
        this(Paths.get(string, new String[0]));
    }

    public ResolverAnonymous(Path path) {
        this.resourcePath = path;
    }

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        try {
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(Files.newInputStream(this.resourcePath, new OpenOption[0]));
            xMLSignatureInput.setSecureValidation(resourceResolverContext.secureValidation);
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new ResourceResolverException(iOException, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri, "generic.EmptyMessage");
        }
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext resourceResolverContext) {
        return resourceResolverContext.uriToResolve == null;
    }
}

