/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelByteBufferWavetable;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.SimpleInstrument;
import com.sun.media.sound.SimpleSoundbank;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class AudioFileSoundbankReader
extends SoundbankReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);){
            Soundbank soundbank2;
            Soundbank soundbank = soundbank2 = this.getSoundbank(audioInputStream);
            return soundbank;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        inputStream.mark(512);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            Soundbank soundbank = this.getSoundbank(audioInputStream);
            if (soundbank != null) {
                return soundbank;
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputStream.reset();
        return null;
    }

    public Soundbank getSoundbank(AudioInputStream audioInputStream) throws InvalidMidiDataException, IOException {
        int n = 0x100000;
        int n2 = 65536;
        int n3 = 1024;
        try {
            byte[] byArray;
            Object object;
            Object object2;
            int n4 = audioInputStream.getFormat().getFrameSize();
            if (n4 <= 0 || n4 > n3) {
                throw new InvalidMidiDataException("Formats with frame size " + n4 + " are not supported");
            }
            long l = audioInputStream.getFrameLength() * (long)n4;
            if (l >= 0x7FFFFFFDL) {
                throw new InvalidMidiDataException("Can not allocate enough memory to read audio data.");
            }
            if (audioInputStream.getFrameLength() == -1L || l > (long)n) {
                int n5;
                object2 = new ByteArrayOutputStream();
                object = new byte[n2 - n2 % n4];
                while ((n5 = audioInputStream.read((byte[])object)) != -1) {
                    ((ByteArrayOutputStream)object2).write((byte[])object, 0, n5);
                }
                audioInputStream.close();
                byArray = ((ByteArrayOutputStream)object2).toByteArray();
            } else {
                byArray = new byte[(int)l];
                new DataInputStream(audioInputStream).readFully(byArray);
            }
            object2 = new ModelByteBufferWavetable(new ModelByteBuffer(byArray), audioInputStream.getFormat(), -4800.0f);
            object = new ModelPerformer();
            ((ModelPerformer)object).getOscillators().add((ModelOscillator)object2);
            SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
            SimpleInstrument simpleInstrument = new SimpleInstrument();
            simpleInstrument.add((ModelPerformer)object);
            simpleSoundbank.addInstrument(simpleInstrument);
            return simpleSoundbank;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            audioInputStream.close();
            ModelByteBufferWavetable modelByteBufferWavetable = new ModelByteBufferWavetable(new ModelByteBuffer(file, 0L, file.length()), -4800.0f);
            ModelPerformer modelPerformer = new ModelPerformer();
            modelPerformer.getOscillators().add(modelByteBufferWavetable);
            SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
            SimpleInstrument simpleInstrument = new SimpleInstrument();
            simpleInstrument.add(modelPerformer);
            simpleSoundbank.addInstrument(simpleInstrument);
            return simpleSoundbank;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

