/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)algorithmParameterSpec).getP();
        this.q = ((DSAParameterSpec)algorithmParameterSpec).getQ();
        this.g = ((DSAParameterSpec)algorithmParameterSpec).getG();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            throw new IOException("DSA params parsing error");
        }
        derValue.getData().reset();
        this.p = derValue.getData().getInteger();
        this.q = derValue.getData().getInteger();
        this.g = derValue.getData().getInteger();
        if (derValue.getData().available() != 0) {
            throw new IOException("encoded params have " + derValue.getData().available() + " extra bytes");
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName("java.security.spec.DSAParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)new DSAParameterSpec(this.p, this.q, this.g);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.p);
        derOutputStream2.putInteger(this.q);
        derOutputStream2.putInteger(this.g);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return "p: " + this.p + ", q: " + this.q + ", g: " + this.g;
    }
}

