/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.security.auth.DomainIDPrincipal;
import com.ibm.security.auth.DomainPrincipal;
import com.ibm.security.auth.GroupIDPrincipal;
import com.ibm.security.auth.NTNumericCredential;
import com.ibm.security.auth.PrimaryGroupIDPrincipal;
import com.ibm.security.auth.UserIDPrincipal;
import com.ibm.security.auth.UsernamePrincipal;
import com.ibm.security.auth.module.NTSystem;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@Deprecated
public class NTLoginModule2000
implements LoginModule {
    private NTSystem ntSystem;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean debugNative = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UsernamePrincipal userPrincipal;
    private UserIDPrincipal userSID;
    private DomainPrincipal userDomain;
    private DomainIDPrincipal domainSID;
    private PrimaryGroupIDPrincipal primaryGroup;
    private GroupIDPrincipal[] groups;
    private NTNumericCredential numericCredential;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        this.debugNative = "true".equalsIgnoreCase((String)map2.get("debugNative"));
        if (this.debugNative) {
            this.debug = true;
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.succeeded = false;
        boolean bl = true;
        this.ntSystem = new NTSystem(this.debugNative);
        if (this.ntSystem == null) {
            if (this.debug) {
                System.out.println("\t\t[NTLoginModule2000] Failed in NT login");
            }
            throw new FailedLoginException("Failed in attempt to import the underlying NT system identity information");
        }
        if (this.ntSystem.getName() == null) {
            throw new FailedLoginException("Failed in attempt to import the underlying NT system identity information");
        }
        this.userPrincipal = new UsernamePrincipal(this.ntSystem.getName(), bl);
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule2000] succeeded importing info: ");
            System.out.println("\t\t\tuser name = " + this.userPrincipal.getName());
        }
        if (this.ntSystem.getUserSID() != null) {
            this.userSID = new UserIDPrincipal(this.ntSystem.getUserSID(), bl);
            if (this.debug) {
                System.out.println("\t\t\tuser SID = " + this.userSID.getName());
            }
        }
        if (this.ntSystem.getDomain() != null) {
            this.userDomain = new DomainPrincipal(this.ntSystem.getDomain(), bl);
            if (this.debug) {
                System.out.println("\t\t\tuser domain = " + this.userDomain.getName());
            }
        }
        if (this.ntSystem.getDomainSID() != null) {
            this.domainSID = new DomainIDPrincipal(this.ntSystem.getDomainSID(), bl);
            if (this.debug) {
                System.out.println("\t\t\tuser domain SID = " + this.domainSID.getName());
            }
        }
        if (this.ntSystem.getPrimaryGroupID() != null) {
            this.primaryGroup = new PrimaryGroupIDPrincipal(this.ntSystem.getPrimaryGroupID(), bl);
            if (this.debug) {
                System.out.println("\t\t\tuser primary group = " + this.primaryGroup.getName());
            }
        }
        if (this.ntSystem.getGroupIDs() != null && this.ntSystem.getGroupIDs().length > 0) {
            String[] stringArray = this.ntSystem.getGroupIDs();
            this.groups = new GroupIDPrincipal[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.groups[i] = new GroupIDPrincipal(stringArray[i], bl);
                if (!this.debug) continue;
                System.out.println("\t\t\tuser group = " + this.groups[i].getName());
            }
        }
        if (this.ntSystem.getImpersonationToken() != 0L) {
            this.numericCredential = new NTNumericCredential((int)this.ntSystem.getImpersonationToken(), this.ntSystem);
            if (this.debug) {
                System.out.println("\t\t\tnumeric credential = " + this.numericCredential.getToken());
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[NTLoginModule2000]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.userPrincipal)) {
            set.add(this.userPrincipal);
        }
        if (this.userSID != null && !set.contains(this.userSID)) {
            set.add(this.userSID);
        }
        if (this.userDomain != null && !set.contains(this.userDomain)) {
            set.add(this.userDomain);
        }
        if (this.domainSID != null && !set.contains(this.domainSID)) {
            set.add(this.domainSID);
        }
        if (this.primaryGroup != null && !set.contains(this.primaryGroup)) {
            set.add(this.primaryGroup);
        }
        for (int i = 0; this.groups != null && i < this.groups.length; ++i) {
            if (set.contains(this.groups[i])) continue;
            set.add(this.groups[i]);
        }
        if (this.numericCredential != null && !this.subject.getPublicCredentials().contains(this.numericCredential)) {
            this.subject.getPublicCredentials().add(this.numericCredential);
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule2000]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.ntSystem = null;
            this.userPrincipal = null;
            this.userSID = null;
            this.userDomain = null;
            this.domainSID = null;
            this.primaryGroup = null;
            this.groups = null;
            this.numericCredential = null;
            this.succeeded = false;
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (set.contains(this.userPrincipal)) {
            set.remove(this.userPrincipal);
        }
        if (set.contains(this.userSID)) {
            set.remove(this.userSID);
        }
        if (set.contains(this.userDomain)) {
            set.remove(this.userDomain);
        }
        if (set.contains(this.domainSID)) {
            set.remove(this.domainSID);
        }
        if (set.contains(this.primaryGroup)) {
            set.remove(this.primaryGroup);
        }
        for (int i = 0; this.groups != null && i < this.groups.length; ++i) {
            if (!set.contains(this.groups[i])) continue;
            set.remove(this.groups[i]);
        }
        Set<Object> set2 = this.subject.getPublicCredentials();
        if (set2.contains(this.numericCredential)) {
            set2.remove(this.numericCredential);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.ntSystem.logoff();
        this.userPrincipal = null;
        this.userDomain = null;
        this.userSID = null;
        this.domainSID = null;
        this.groups = null;
        this.primaryGroup = null;
        this.numericCredential = null;
        this.ntSystem = null;
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule2000] completed logout processing");
        }
        return true;
    }
}

