/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.MemorySafetyService;

public class GlobalMap<K, V> {
    private static int DEFAULT_BLOCK_PAIRS = 6;
    private int block_size;
    Object[] head;
    K lastKey;
    V lastValue;

    public GlobalMap() {
        this(DEFAULT_BLOCK_PAIRS);
    }

    public GlobalMap(int n) {
        if (MemorySafetyService.isSafeMode()) assert (MemorySafetyService.isObjectOnSafeArea((Object)this));
        this.block_size = n * 2 + 1;
    }

    public synchronized V getItem(K k) {
        if (k == this.lastKey) {
            return this.lastValue;
        }
        Object[] objectArray = this.head;
        while (objectArray != null) {
            for (int i = 1; i < objectArray.length; i += 2) {
                Object object = objectArray[i];
                if (!k.equals(object)) continue;
                this.lastKey = k;
                this.lastValue = objectArray[i + 1];
                return (V)objectArray[i + 1];
            }
            objectArray = (Object[])objectArray[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putItem(K k, V v) {
        Object[] objectArray;
        if (MemorySafetyService.isSafeMode()) {
            assert (MemorySafetyService.isObjectOnSafeArea(k));
            assert (MemorySafetyService.isObjectOnSafeArea(v));
        }
        this.lastKey = k;
        this.lastValue = v;
        if (this.head != null) {
            for (int i = 1; i < this.head.length; i += 2) {
                if (this.head[i] != null) continue;
                this.head[i] = k;
                this.head[i + 1] = v;
                return;
            }
        }
        long l = -1L;
        try {
            l = MemorySafetyService.enterSafeMemoryArea();
            objectArray = new Object[this.block_size];
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
        objectArray[0] = this.head;
        objectArray[1] = k;
        objectArray[2] = v;
        this.head = objectArray;
    }
}

