/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.thread.IThreadTypes;
import java.util.regex.Matcher;

public class NativeStackTraceLineRule
extends LineRule
implements IThreadTypes {
    private final Matcher mb = CommonPatternMatchers.generateMatcher("\\[");
    private final Matcher sign = CommonPatternMatchers.generateMatcher("[-+]");
    private final Matcher spaceparen = CommonPatternMatchers.generateMatcher("\\s*\\(");

    @Override
    protected void processLine(String source, int startingOffset) {
        int sourceIndex;
        this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
        IParserToken routine = this.addAllCharactersAsTokenAndConsumeFirstMatch("stack_routine", this.spaceparen);
        if (routine != null) {
            String val = routine.getValue();
            this.sign.reset(val);
            if (this.sign.find()) {
                this.addToken("stack_routine", val.substring(0, this.sign.start()));
                CommonPatternMatchers.signed_hex_0x.reset(val);
                if (CommonPatternMatchers.signed_hex_0x.find()) {
                    this.addToken("stack_routine_offset", CommonPatternMatchers.signed_hex_0x.group());
                }
            }
        }
        if ((sourceIndex = this.indexOfLast(CommonPatternMatchers.comma)) >= 0) {
            int sourceIndex2 = this.indexOfLast(CommonPatternMatchers.colon);
            if (sourceIndex2 < sourceIndex) {
                this.addAllCharactersAsTokenAndConsumeFirstMatch("stack_file", CommonPatternMatchers.colon);
                this.addToken("stack_line", CommonPatternMatchers.dec);
            } else {
                this.addAllCharactersAsTokenAndConsumeFirstMatch("stack_file", CommonPatternMatchers.comma);
            }
        }
        this.addPrefixedHexToken("stack_proc_address");
        this.consumeUntilFirstMatch(this.mb);
        this.addAllCharactersAsTokenUntilFirstMatch("stack_module", this.sign);
        this.addToken("stack_module_offset", CommonPatternMatchers.signed_hex_0x);
    }
}

