/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNamesException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class GeneralNames
extends Vector
implements DistributionPointName {
    static final long serialVersionUID = 937266807388640626L;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralNames";

    public GeneralNames(DerValue derVal) throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralNames", derVal);
        }
        if (derVal.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralNames", "Invalid encoding for GeneralNames.");
            }
            throw new IOException("Invalid encoding for GeneralNames.");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralNames", "No data available in passed DER encoded value.");
            }
            throw new GeneralNamesException("No data available in passed DER encoded value.");
        }
        while (derVal.getData().available() != 0) {
            DerValue encName = derVal.getData().getDerValue();
            GeneralName name = new GeneralName(encName);
            super.addElement(name);
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralNames");
        }
    }

    public GeneralNames() {
        super(1, 1);
        if (debug != null) {
            debug.entry(16384L, className, "GeneralNames");
            debug.exit(16384L, className, "GeneralNames");
        }
    }

    public GeneralNames add(GeneralName name) {
        if (debug != null) {
            debug.entry(16384L, className, "add");
        }
        if (name == null) {
            if (debug != null) {
                debug.exit(16384L, className, "add");
            }
            throw new NullPointerException();
        }
        super.add(name);
        if (debug != null) {
            debug.exit(16384L, className, "add");
        }
        return this;
    }

    @Override
    public GeneralName get(int index) {
        if (debug != null) {
            debug.entry(16384L, className, "get");
            debug.exit(16384L, className, "get");
        }
        return (GeneralName)super.get(index);
    }

    public List<GeneralName> names() {
        if (debug != null) {
            debug.entry(16384L, className, "names");
            debug.exit(16384L, className, "names");
        }
        ArrayList<GeneralName> newList = new ArrayList<GeneralName>();
        for (int i = 0; i < this.size(); ++i) {
            newList.add(i, this.get(i));
        }
        return newList;
    }

    @Override
    public boolean isEmpty() {
        if (debug != null) {
            debug.entry(16384L, className, "isEmpty");
            debug.exit(16384L, className, "isEmpty");
        }
        return super.isEmpty();
    }

    @Override
    public int size() {
        if (debug != null) {
            debug.entry(16384L, className, "size");
            debug.exit(16384L, className, "size");
        }
        return super.size();
    }

    @Override
    public Iterator<GeneralName> iterator() {
        if (debug != null) {
            debug.entry(16384L, className, "Iterator<GeneralName>");
            debug.exit(16384L, className, "Iterator<GeneralName>");
        }
        return super.iterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, className, "equals");
            debug.exit(16384L, className, "equals");
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, className, "hashCode");
        }
        return super.hashCode();
    }

    @Override
    public GeneralNames clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
            debug.exit(16384L, className, "clone");
        }
        return (GeneralNames)super.clone();
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, className, "toString");
        }
        return super.toString();
    }

    public void encode(DerOutputStream out) throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.size() == 0) {
            return;
        }
        Enumeration names = this.elements();
        DerOutputStream temp = new DerOutputStream();
        while (names.hasMoreElements()) {
            Object obj = names.nextElement();
            if (!(obj instanceof GeneralNameInterface)) {
                if (debug != null) {
                    debug.text(16384L, className, "encode", "Element in GeneralNames not of type GeneralName.");
                }
                throw new GeneralNamesException("Element in GeneralNames not of type GeneralName.");
            }
            GeneralNameInterface intf = (GeneralNameInterface)obj;
            DerOutputStream gname = new DerOutputStream();
            intf.encode(gname);
            int nameType = intf.getType();
            if (nameType == 4) {
                DerValue derval = new DerValue(gname.toByteArray());
                if (derval.isContextSpecific()) {
                    temp.write(gname.toByteArray());
                    continue;
                }
                temp.write(DerValue.createTag((byte)-128, true, (byte)nameType), gname);
                continue;
            }
            if (nameType == 0 || nameType == 3 || nameType == 5) {
                temp.writeImplicit(DerValue.createTag((byte)-128, true, (byte)nameType), gname);
                continue;
            }
            temp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)nameType), gname);
        }
        out.write((byte)48, temp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream derout = new DerOutputStream();
        try {
            this.encode(derout);
        }
        catch (GeneralNamesException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new IOException("Error encoding a GeneralNames element.");
        }
        out.write(derout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public GeneralName getGeneralName(int type) throws GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getGeneralName", new Integer(type));
        }
        if (this.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getGeneralName_1", null);
            }
            return null;
        }
        Enumeration names = super.elements();
        while (names.hasMoreElements()) {
            Object obj = names.nextElement();
            if (!(obj instanceof GeneralNameInterface)) {
                if (debug != null) {
                    debug.text(16384L, className, "getGeneralName", "Element in GeneralNames not of type GeneralName.");
                }
                throw new GeneralNamesException("Element in GeneralNames not of type GeneralName.");
            }
            GeneralName intf = (GeneralName)obj;
            if (intf.getType() != type) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getGeneralName_2", intf);
            }
            return intf;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getGeneralName_3", null);
        }
        return null;
    }
}

