/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.CRLDistributionPoints";
    public static final String NAME = "CRLDistributionPoints";
    public static final String POINTS = "points";
    public static final String DISTRIBUTION_PTS = "points";
    private List<DistributionPoint> distributionPoints;
    private String extensionName;
    private DistributionPoint[] dPoints = null;

    public CRLDistributionPointsExtension(DistributionPoint[] distributionPoints) throws IOException {
        this(false, Arrays.asList(distributionPoints));
    }

    public CRLDistributionPointsExtension(List<DistributionPoint> distributionPoints) throws IOException {
        this(false, distributionPoints);
    }

    public CRLDistributionPointsExtension(boolean isCritical, DistributionPoint[] distributionPoints) throws IOException {
        this(PKIXExtensions.CRLDistributionPoints_Id, isCritical, Arrays.asList(distributionPoints), NAME);
    }

    public CRLDistributionPointsExtension(boolean isCritical, List<DistributionPoint> distributionPoints) throws IOException {
        this(PKIXExtensions.CRLDistributionPoints_Id, isCritical, distributionPoints, NAME);
    }

    protected CRLDistributionPointsExtension(ObjectIdentifier extensionId, boolean isCritical, DistributionPoint[] distributionPoints, String extensionName) throws IOException {
        this(extensionId, isCritical, Arrays.asList(distributionPoints), extensionName);
    }

    protected CRLDistributionPointsExtension(ObjectIdentifier extensionId, boolean isCritical, List<DistributionPoint> distributionPoints, String extensionName) throws IOException {
        this.extensionId = extensionId;
        this.critical = isCritical;
        this.distributionPoints = distributionPoints;
        this.encodeThis();
        this.extensionName = extensionName;
    }

    public CRLDistributionPointsExtension(Boolean critical, byte[] value) throws IOException {
        this(PKIXExtensions.CRLDistributionPoints_Id, critical, value, NAME);
    }

    public CRLDistributionPointsExtension(Boolean critical, Object value) throws IOException {
        this(PKIXExtensions.CRLDistributionPoints_Id, critical, value, NAME);
    }

    protected CRLDistributionPointsExtension(ObjectIdentifier extensionId, Boolean critical, Object value, String extensionName) throws IOException {
        this.extensionId = extensionId;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for " + extensionName + " extension.");
        }
        this.distributionPoints = new ArrayList<DistributionPoint>();
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            DistributionPoint point = new DistributionPoint(seq);
            this.distributionPoints.add(point);
        }
        this.extensionName = extensionName;
    }

    public CRLDistributionPointsExtension(DerValue derval) throws IOException {
        super(derval);
        this.decodeThis();
    }

    @Override
    public String getName() {
        return this.extensionName;
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] result = (DistributionPoint[])this.distributionPoints.toArray();
        return result;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        this.encode(out, PKIXExtensions.CRLDistributionPoints_Id, false);
    }

    public void encode(OutputStream out, ObjectIdentifier extensionId) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = extensionId;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    protected void encode(OutputStream out, ObjectIdentifier extensionId, boolean isCritical) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = extensionId;
            this.critical = isCritical;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase("points")) {
            if (!(obj instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:" + this.extensionName + '.');
        }
        this.distributionPoints = (List)obj;
        this.encodeThis();
    }

    public DistributionPoint[] get(String name) throws IOException {
        if (name.equalsIgnoreCase("points")) {
            DistributionPoint[] distributionPointArray = new DistributionPoint[this.distributionPoints.size()];
            int arrayIndex = 0;
            Iterator<DistributionPoint> myIter = this.distributionPoints.iterator();
            while (myIter.hasNext()) {
                DistributionPoint myDistributionPoint;
                distributionPointArray[arrayIndex] = myDistributionPoint = myIter.next();
                ++arrayIndex;
            }
            return distributionPointArray;
        }
        throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:" + this.extensionName + '.');
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase("points")) {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:" + this.extensionName + '.');
        }
        this.distributionPoints = Collections.emptyList();
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement("points");
        return elements.elements();
    }

    private void encodeThis() throws IOException {
        if (this.distributionPoints.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream pnts = new DerOutputStream();
            for (DistributionPoint point : this.distributionPoints) {
                point.encode(pnts);
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, pnts);
            this.extensionValue = seq.toByteArray();
        }
    }

    private void decodeThis() throws IOException {
        DerValue derVal = new DerValue(this.extensionValue);
        if (derVal.getTag() != 48) {
            throw new IOException("CRLDistributionPointsExtension parsing error: not a SEQUENCE.");
        }
        if (derVal.getData().available() == 0) {
            throw new IOException("No data available in DER encoded value.");
        }
        ArrayList<DistributionPoint> dPointsList = new ArrayList<DistributionPoint>();
        while (derVal.getData() != null && derVal.getData().available() != 0) {
            DerValue derVal2 = derVal.getData().getDerValue();
            DistributionPoint dp = new DistributionPoint(derVal2.toByteArray());
            dPointsList.add(dp);
        }
        if (dPointsList.size() > 0) {
            this.dPoints = new DistributionPoint[dPointsList.size()];
            for (int i = 0; i < dPointsList.size(); ++i) {
                this.dPoints[i] = (DistributionPoint)dPointsList.get(i);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + this.extensionName + " [\n  " + this.distributionPoints + "]\n";
    }
}

