/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAddressFinder {
    private final Logger logger;
    private static final String _127 = "127.";
    private String localAddress = null;
    private static final int NUM_CONNECTION_TYPES = 3;
    private static final String[][] INTERFACE_NAMES = new String[][]{{Messages.getString("NetworkAddressFinder.eth0"), Messages.getString("NetworkAddressFinder.eth1")}, {Messages.getString("NetworkAddressFinder.wlan0")}, {Messages.getString("NetworkAddressFinder.wc0")}};
    private String[] localAddresses = new String[3];

    public NetworkAddressFinder() {
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        this.findAllNetworkInterfaces();
        this.calculateLocalAddress();
    }

    private void findAllNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                this.doStuffWithInterface(ni);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    private void doStuffWithInterface(NetworkInterface ni) {
        String name = ni.getName();
        if (this.isLoopback(ni)) {
            return;
        }
        int thisInterfaceType = -1;
        for (int i = 0; i < INTERFACE_NAMES.length; ++i) {
            for (int j = 0; j < INTERFACE_NAMES[i].length; ++j) {
                if (!INTERFACE_NAMES[i][j].equals(name)) continue;
                thisInterfaceType = i;
            }
        }
        if (thisInterfaceType != -1) {
            Enumeration<InetAddress> i = ni.getInetAddresses();
            while (i.hasMoreElements()) {
                this.doStuffWithInetAddress(thisInterfaceType, i);
            }
        }
    }

    private void doStuffWithInetAddress(int thisInterfaceType, Enumeration<InetAddress> i) {
        InetAddress ia = i.nextElement();
        if (ia instanceof Inet4Address) {
            String ipAddress;
            this.localAddresses[thisInterfaceType] = ipAddress = ia.getHostAddress();
        } else if (!(ia instanceof Inet6Address)) {
            this.logger.warning(MessageFormat.format(Messages.getString("NetworkAddressFinder.unknown.address.class"), ia.getClass()));
        }
    }

    private boolean isLoopback(NetworkInterface ni) {
        return ni.getName().startsWith(_127);
    }

    private void calculateLocalAddress() {
        for (int i = 0; i < this.localAddresses.length; ++i) {
            this.localAddress = this.localAddresses[i];
            if (this.localAddress == null) continue;
            return;
        }
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public boolean defaultAddressIsUnreliable() {
        boolean dodgy = false;
        if (!System.getProperty("os.name").contains("Windows")) {
            try {
                String hostName;
                InetAddress localHost = InetAddress.getLocalHost();
                if (localHost != null && (hostName = localHost.getHostAddress()) != null && hostName.startsWith(_127)) {
                    dodgy = true;
                }
            }
            catch (UnknownHostException e) {
                dodgy = true;
            }
        }
        return dodgy;
    }
}

