/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public class MemoryDataProvider {
    private static final String COMMA = ",";
    private static final String EQUALS = "=";

    public static String getJMXData() {
        return MemoryDataProvider.getMemoryInformation();
    }

    private static String getMemoryInformation() {
        String memoryReport = "MemorySource," + System.currentTimeMillis() + COMMA + "totalphysicalmemory" + EQUALS + MemoryDataProvider.getPhysicalMemorySizeImpl() + COMMA;
        return memoryReport;
    }

    public boolean isDataSupported() {
        boolean available = true;
        String osName = System.getProperty("os.name");
        if ("i5/OS".equals(osName) || "OS/400".equals(osName)) {
            available = false;
        }
        return available;
    }

    private static long getPhysicalMemorySizeImpl() {
        Class[] noparams = new Class[]{};
        long result = -1L;
        if (!System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> sunBeanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                OperatingSystemMXBean sunBean = ManagementFactory.getOperatingSystemMXBean();
                Method sunMethod = sunBeanClass.getDeclaredMethod("getTotalPhysicalMemorySize", noparams);
                Long sunResult = (Long)sunMethod.invoke((Object)sunBean, (Object[])null);
                if (sunResult != null) {
                    result = sunResult;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else if (System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> ibmBeanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                OperatingSystemMXBean ibmBean = ManagementFactory.getOperatingSystemMXBean();
                Method ibmMethod = ibmBeanClass.getDeclaredMethod("getTotalPhysicalMemory", noparams);
                Long ibmResult = (Long)ibmMethod.invoke((Object)ibmBean, (Object[])null);
                if (ibmResult != null) {
                    result = ibmResult;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return result;
    }
}

