/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.RoundInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;

public class RoundEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        RoundInstruction roundInstruction = (RoundInstruction)instruction;
        Instruction instruction2 = roundInstruction.getOperand();
        partialInformationCollector.partiallyEvaluate(instruction2, letChainManager);
        Object object = RoundEvaluator.extractLiteralValue(partialInformationCollector, instruction2, letChainManager);
        if (object != null) {
            if (object instanceof Double) {
                return new PartialEvaluationResult(LiteralInstruction.doubleLiteral(Math.round((Double)object)));
            }
            if (object instanceof Float) {
                return new PartialEvaluationResult(LiteralInstruction.floatLiteral(Math.round(((Float)object).floatValue())));
            }
            if (object instanceof Integer) {
                return new PartialEvaluationResult(LiteralInstruction.integerLiteral((Integer)object));
            }
            if (object instanceof Long) {
                return new PartialEvaluationResult(LiteralInstruction.longLiteral((Long)object));
            }
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

