/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xml.jaxp.util.HashtableFactory;
import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xtq.ast.nodes.KindTest;
import com.ibm.xtq.ast.nodes.NameTest;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.StepExpr;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.TestSeq;
import com.ibm.xtq.xslt.translator.TranslatorBase;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.translator.v2.XSLTC2Helper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;

public final class Mode
implements Constants,
XPathTreeConstants {
    public static final String APPLY_TEMPLATES = "applyTemplates";
    private final QName _name;
    private final XTQProgram _stylesheet;
    private final String _methodName;
    private List _templates;
    private List _childNodeGroup = null;
    private TestSeq _childNodeTestSeq = null;
    private List _attribNodeGroup = null;
    private List _idxGroup = null;
    private TestSeq _idxTestSeq = null;
    private List[] _patternGroups;
    private TestSeq[] _testSeq;
    private Hashtable _neededTemplates = HashtableFactory.newHashtable();
    private Hashtable _namedTemplates = HashtableFactory.newHashtable();
    private Expr _rootPattern = null;
    private Hashtable _importLevels = null;
    private Hashtable _keys = null;
    private TranslatorBase _translator;
    private int _modeNumber;

    public Mode(QName qName, TranslatorBase translatorBase, XTQProgram xTQProgram, String string) {
        this._name = qName;
        if (this._name == null) {
            // empty if block
        }
        this._translator = translatorBase;
        this._stylesheet = xTQProgram;
        this._methodName = APPLY_TEMPLATES + string;
        this._templates = new ArrayList();
        this._patternGroups = new ArrayList[32];
        this._modeNumber = string.equals("") ? 0 : Integer.valueOf(string);
    }

    public void setTranslator(TranslatorBase translatorBase) {
        this._translator = translatorBase;
    }

    public TranslatorBase getTranslator() {
        return this._translator;
    }

    public String functionName() {
        return this._methodName;
    }

    public String functionName(int n, int n2) {
        if (this._importLevels == null) {
            this._importLevels = HashtableFactory.newHashtable();
        }
        this._importLevels.put(new Integer(n2), new Integer(n));
        return this._methodName + '_' + n2;
    }

    public XTQProgram getStylesheet() {
        return this._stylesheet;
    }

    public void addTemplate(Template template) {
        this._templates.add(template);
    }

    public void processPatterns(Hashtable hashtable, int n) {
        this._keys = hashtable;
        for (Template template : this._templates) {
            Expr expr;
            if (template.isNamed() && !template.isDisabled()) {
                this._namedTemplates.put(template, this);
            }
            if ((expr = template.getPattern()) == null) continue;
            this.flattenAlternative(expr, template, hashtable, n);
        }
        this.prepareTestSequences();
    }

    private void flattenAlternative(Expr expr, Template template, Hashtable hashtable, int n) {
        if (expr instanceof IdOrKeyFunctionCallPattern) {
            ASTDecorator.setPatternPriority(expr, XSLTCHelper.getPatternPriority(expr));
            if (this._idxGroup == null) {
                this._idxGroup = new ArrayList();
            }
            this._idxGroup.add(expr);
            this.addPatternToGroup(expr);
        } else if (XSLTCHelper.isUnionPattern(expr)) {
            OperatorExpr operatorExpr = (OperatorExpr)expr;
            Expr expr2 = operatorExpr.getOperand(0);
            Expr expr3 = operatorExpr.getOperand(1);
            this.flattenAlternative(expr2, template, hashtable, n);
            this.flattenAlternative(expr3, template, hashtable, n);
        } else if (expr.getId() == 187 || expr.getId() == 188 || expr.getId() == 84 || expr.getId() == 105 && ((FunctionCall)expr).getQName().getLocalPart().equals("root")) {
            if (n == 1) {
                ASTDecorator.setPatternPriority(expr, XSLTCHelper.getPatternPriority(expr));
            } else {
                ASTDecorator.setPatternPriority(expr, XSLTC2Helper.getPatternPriority(expr));
            }
            if (expr instanceof StepExpr) {
                StepExpr stepExpr = (StepExpr)expr;
                Expr expr4 = (Expr)stepExpr.jjtGetChild(0);
                if (expr4 instanceof KindTest) {
                    XSLTParser xSLTParser = this._translator.getParser();
                    short s = ((KindTest)expr4).getKindTestType();
                    if (s == 0) {
                        XSLTCHelper.processingInstructionTestRewrite(stepExpr, xSLTParser);
                    } else if (s == 4 && ((KindTest)expr4).getElementTest() != null) {
                        XSLTC2Helper.documentTestRewrite(xSLTParser, stepExpr, xSLTParser);
                    }
                } else if (expr4 instanceof NameTest) {
                    NameTest nameTest = (NameTest)expr4;
                    short s = nameTest.getNameTestType();
                    XSLTParser xSLTParser = this._translator.getParser();
                    if (s == 1) {
                        if (n == 1) {
                            XSLTCHelper.nameTestRewrite(stepExpr, xSLTParser, true);
                        } else {
                            XSLTC2Helper.nameTestRewrite(stepExpr, xSLTParser);
                        }
                    } else if (s == 2) {
                        XSLTC2Helper.nameTestRewrite(stepExpr, xSLTParser);
                    }
                }
            }
            this.addPatternToGroup(expr);
        }
    }

    private void addPatternToGroup(Expr expr) {
        if (expr instanceof IdOrKeyFunctionCallPattern) {
            this.addPattern(-1, expr);
        } else {
            StepExpr stepExpr = XSLTCHelper.getKernelPattern(expr);
            if (stepExpr != null) {
                int n = stepExpr.getStepNodeType();
                int n2 = -1;
                try {
                    n2 = stepExpr.getAxisType();
                }
                catch (XPath20Exception xPath20Exception) {
                    // empty catch block
                }
                if (n2 == 1 && n == 2) {
                    return;
                }
                if (n2 == 4 && n < 14) {
                    n = 2;
                }
                this.addPattern(n, expr);
            } else if (this._rootPattern == null || XSLTCHelper.noSmallerThan(expr, this._rootPattern)) {
                this._rootPattern = expr;
            }
        }
    }

    private void addPattern(int n, Expr expr) {
        Object object;
        int n2 = this._patternGroups.length;
        if (n >= n2) {
            object = new ArrayList[n * 2];
            System.arraycopy(this._patternGroups, 0, object, 0, n2);
            this._patternGroups = object;
        }
        if (n == -1) {
            object = XSLTCHelper.getAxisForPattern(expr) == 4 ? (this._attribNodeGroup == null ? (this._attribNodeGroup = new ArrayList(2)) : this._attribNodeGroup) : (this._childNodeGroup == null ? (this._childNodeGroup = new ArrayList(2)) : this._childNodeGroup);
        } else {
            Object object2 = object = this._patternGroups[n] == null ? new ArrayList(2) : this._patternGroups[n];
        }
        if (object.size() == 0) {
            object.add(expr);
        } else {
            boolean bl = false;
            for (int i = 0; i < object.size(); ++i) {
                Expr expr2 = (Expr)object.get(i);
                if (!XSLTCHelper.noSmallerThan(expr, expr2)) continue;
                bl = true;
                object.add(i, expr);
                break;
            }
            if (!bl) {
                object.add(expr);
            }
        }
    }

    private void completeTestSequences(int n, List list) {
        if (list != null) {
            if (this._patternGroups[n] == null) {
                this._patternGroups[n] = list;
            } else {
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    this.addPattern(n, (Expr)list.get(i));
                }
            }
        }
    }

    private void prepareTestSequences() {
        Object object;
        int n;
        int n2;
        List list = this._patternGroups[1];
        List list2 = this._patternGroups[2];
        this.completeTestSequences(3, this._childNodeGroup);
        this.completeTestSequences(1, this._childNodeGroup);
        this.completeTestSequences(7, this._childNodeGroup);
        this.completeTestSequences(8, this._childNodeGroup);
        this.completeTestSequences(2, this._attribNodeGroup);
        List list3 = this._translator.getCompiler().getNamesIndex();
        if (list != null || list2 != null || this._childNodeGroup != null || this._attribNodeGroup != null) {
            n2 = this._patternGroups.length;
            for (n = 14; n < n2; ++n) {
                if (this._patternGroups[n] == null) continue;
                object = (String)list3.get(n - 14);
                if (Mode.isAttributeName((String)object)) {
                    this.completeTestSequences(n, list2);
                    this.completeTestSequences(n, this._attribNodeGroup);
                    continue;
                }
                this.completeTestSequences(n, list);
                this.completeTestSequences(n, this._childNodeGroup);
            }
        }
        this._testSeq = new TestSeq[14 + list3.size()];
        n2 = this._patternGroups.length;
        for (n = 0; n < n2; ++n) {
            object = this._patternGroups[n];
            if (object == null) continue;
            TestSeq testSeq = new TestSeq((List)object, n, this);
            testSeq.reduce();
            this._testSeq[n] = testSeq;
            testSeq.findTemplates(this._neededTemplates);
        }
        if (this._childNodeGroup != null && this._childNodeGroup.size() > 0) {
            this._childNodeTestSeq = new TestSeq(this._childNodeGroup, -1, this);
            this._childNodeTestSeq.reduce();
            this._childNodeTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._idxGroup != null && this._idxGroup.size() > 0) {
            this._idxTestSeq = new TestSeq(this._idxGroup, this);
            this._idxTestSeq.reduce();
            this._idxTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._rootPattern != null) {
            this._neededTemplates.put(XSLTCHelper.getTemplateForPattern(this._rootPattern), this);
        }
    }

    private static boolean isAttributeName(String string) {
        int n = string.lastIndexOf(58) + 1;
        return string.charAt(n) == '@';
    }

    public final TestSeq[] getTestSeq() {
        return this._testSeq;
    }

    public final List getTemplates() {
        return this._templates;
    }

    public final Expr getRootPattern() {
        return this._rootPattern;
    }

    public final TestSeq getChildNodeTestSeq() {
        this._childNodeTestSeq = null;
        return null;
    }

    private void compileNamedTemplate(Template template, String string) {
        this._translator.compileTemplate(template);
    }

    private void compileTemplates() {
        Template template;
        String string = null;
        string = this._name == null ? "" : this._name.getLocalPart();
        Enumeration enumeration = this._namedTemplates.keys();
        while (enumeration.hasMoreElements()) {
            template = (Template)enumeration.nextElement();
            this.compileNamedTemplate(template, string);
        }
        enumeration = this._neededTemplates.keys();
        while (enumeration.hasMoreElements()) {
            template = (Template)enumeration.nextElement();
            this._translator.compileTemplate(template);
        }
    }

    public void compileApplyTemplates() {
        this.compileTemplates();
    }

    public Hashtable getKeys() {
        return this._keys;
    }

    public int getModeNumber() {
        return this._modeNumber;
    }

    public QName getModeName() {
        return this._name;
    }
}

