/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xpath.jaxp;

import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.scontext.XStaticContext;
import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.jaxp.HandledRuntimeException;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.Module;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.JavaObjectType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.xml.sax.InputSource;

public abstract class XPathImpl
implements XPath {
    public static final String XPATH_FUNCTION = "__xpath_function__";
    public static final String XPATH_MODULE = "XPathModule";
    private XPathFunctionResolver _functionResolver = null;
    private XPathFunctionResolver _origFunctionResolver = null;
    private XPathVariableResolver _variableResolver = null;
    private XPathVariableResolver _origVariableResolver = null;
    private NamespaceContext _namespaceContext = null;
    private boolean _isSecureProcessing = false;
    private boolean _allowNullFcnPrefix = false;

    public XPathImpl(XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver, boolean bl, boolean bl2) {
        this._functionResolver = this._origFunctionResolver = xPathFunctionResolver;
        this._variableResolver = this._origVariableResolver = xPathVariableResolver;
        this._isSecureProcessing = bl;
        this._allowNullFcnPrefix = bl2;
    }

    public XPathImpl() {
    }

    @Override
    public void reset() {
        this._functionResolver = this._origFunctionResolver;
        this._variableResolver = this._origVariableResolver;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_XPATHVARIABLERESOLVER", null));
        }
        this._variableResolver = xPathVariableResolver;
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this._variableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_XPATHFUNCTIONRESOLVER", null));
        }
        this._functionResolver = xPathFunctionResolver;
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this._functionResolver;
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_NAMESPACECONTEXT", null));
        }
        this._namespaceContext = namespaceContext;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._namespaceContext;
    }

    @Override
    public XPathExpression compile(String string) throws XPathExpressionException {
        if (string == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        try {
            return this.doCompile(string);
        }
        catch (HandledRuntimeException handledRuntimeException) {
            throw XPathImpl.convertHandledException(handledRuntimeException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw xPathExpressionException;
        }
        catch (Exception exception) {
            throw new XPathExpressionException(exception);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new XPathExpressionException(XMLMessages.createXMLMessage("ERR_XPATH_COMPILE_STACKOVERFLOWERROR", new Object[]{string}));
        }
    }

    protected abstract XPathExpression doCompile(String var1) throws Exception;

    protected boolean isSecureProcessing() {
        return this._isSecureProcessing;
    }

    protected void initializeStaticContext(ASTBuildingContext aSTBuildingContext) {
        XStaticContext xStaticContext = aSTBuildingContext.getStaticContext();
        xStaticContext.setJAXPFunctionResolver(this._functionResolver);
        xStaticContext.setJAXPVariableResolver(this._variableResolver);
        xStaticContext.setJAXPNamespaceContext(this._namespaceContext);
        xStaticContext.setSecureProcessing(this._isSecureProcessing);
        xStaticContext.setAllowNullFcnPrefix(this._allowNullFcnPrefix);
    }

    @Override
    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object, qName);
    }

    @Override
    public String evaluate(String string, Object object) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object);
    }

    @Override
    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource, qName);
    }

    @Override
    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource);
    }

    protected void addPredefinedFunctions(Module module) {
        Function function = new Function("empty-cursor", new Binding[]{new Binding((Object)"__root__", CursorType.s_cursorType)}, new GetAxisCursorInstruction(10, new IdentifierInstruction("__root__")));
        function.setMemoizeResult(true);
        module.addFunction(function);
    }

    protected void addXDMFunctions(Module module, XPathCompiler xPathCompiler) {
        Function function = new Function("xdm-node-counter-fields", new Binding[0], XSLTLinker.makeStringArrayBody(new String[0]));
        module.addFunction(function);
        module.forceFunctionGeneration(function);
        List list = xPathCompiler.getNamesIndex();
        int n = list.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            int n2 = string.lastIndexOf(58);
            if (n2 > -1) {
                stringArray2[i] = string.substring(0, n2);
            }
            if (string.charAt(++n2) == '@') {
                nArray[i] = 2;
                ++n2;
            } else if (string.charAt(n2) == '%') {
                nArray[i] = 13;
                ++n2;
            } else {
                nArray[i] = 1;
            }
            stringArray[i] = n2 == 0 ? string : string.substring(n2);
        }
        function = new Function("xdm-names", new Binding[0], XSLTLinker.makeStringArrayBody(stringArray));
        module.addFunction(function);
        module.forceFunctionGeneration(function);
        function = new Function("xdm-uris", new Binding[0], XSLTLinker.makeStringArrayBody(stringArray2));
        module.addFunction(function);
        module.forceFunctionGeneration(function);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            objectArray[i] = new Integer(n3);
        }
        function = new Function("xdm-types", new Binding[0], XSLTLinker.makeIntArrayBody(Arrays.asList(objectArray)));
        module.addFunction(function);
        module.forceFunctionGeneration(function);
        List list2 = xPathCompiler.getNamespaceIndex();
        n = list2.size();
        String[] stringArray3 = new String[n];
        list2.toArray(stringArray3);
        function = new Function("xdm-namespaces", new Binding[0], XSLTLinker.makeStringArrayBody(stringArray3));
        module.addFunction(function);
        module.forceFunctionGeneration(function);
        String string = null;
        function = new Function("xdm-encoding", new Binding[]{}, string == null ? LiteralInstruction.nullLiteral(JavaObjectType.s_javaStringType) : new LetInstruction("x", StreamInstruction.charStreamLiteral(string), new CharStreamToJavaStringInstruction(new IdentifierInstruction("x"))));
        module.addFunction(function);
        module.forceFunctionGeneration(function);
    }

    protected static XPathExpressionException convertHandledException(HandledRuntimeException handledRuntimeException) {
        Throwable throwable;
        TransformerException transformerException = handledRuntimeException.getTransformerException();
        Throwable throwable2 = throwable = transformerException != null ? transformerException.getException() : null;
        if (throwable != null) {
            return new XPathExpressionException(throwable);
        }
        return new XPathExpressionException(handledRuntimeException);
    }

    protected void dumpXylem(Module module) {
        try {
            File file = new File(module.getName() + ".xylem");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            module.dump(printWriter);
            printWriter.close();
            printWriter = null;
            outputStreamWriter.close();
            outputStreamWriter = null;
            fileOutputStream.close();
            fileOutputStream = null;
            file = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

