/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.dom;

import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.TreeWalker;
import com.ibm.xtq.common.utils.URI;
import com.ibm.xtq.common.utils.XMLString;
import com.ibm.xtq.common.utils.XMLStringDefault;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XSequenceBase;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.Axis;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMCursor_isReverseEnumerated;
import com.ibm.xtq.xml.xdm.XDMException;
import com.ibm.xtq.xml.xdm.XDMManager;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.XDMSequence;
import com.ibm.xtq.xml.xdm.XDMTreeWalker;
import com.ibm.xtq.xml.xdm.XDMWSFilter;
import com.ibm.xtq.xml.xdm.dom.XDMDocumentState;
import com.ibm.xtq.xml.xdm.dom.XDMManagerDOM;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorAncestor;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorAncestorOrSelf;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorAttribute;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorChild;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorDescendant;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorDescendantOrSelf;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorFollowing;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorFollowingSibling;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorNamespace;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorNamespaceNoXMLDecl;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorNamespaceWithinElement;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorParent;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorPreceding;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorPrecedingSibling;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorRoot;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterCursorTypedProxy;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterSingle;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterTreeWalker;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.transform.SourceLocator;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.ItemPSVI;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.datatypes.ByteList;
import org.apache.xerces.xs.datatypes.XSDateTime;
import org.apache.xerces.xs.datatypes.XSDecimal;
import org.apache.xerces.xs.datatypes.XSDouble;
import org.apache.xerces.xs.datatypes.XSFloat;
import org.apache.xerces.xs.datatypes.XSQName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class XDMNodeAdapter
extends XSequenceBase
implements XDMCursor,
XDMCursor_isReverseEnumerated {
    static final boolean SPEC_EXTYPE_PATCH = true;
    protected Node m_currentNode;
    protected final XDMDocumentState m_dstate;
    public static final int UNDEFINED = -1;

    public XDMNodeAdapter(XDMManagerFactory xDMManagerFactory, XDMWSFilter xDMWSFilter, int n) {
        this.m_dstate = new XDMDocumentState(xDMManagerFactory, xDMWSFilter, n);
    }

    XDMNodeAdapter(XDMDocumentState xDMDocumentState) {
        this.m_dstate = xDMDocumentState;
    }

    public XDMWSFilter getWhiteSpaceFilter() {
        return this.m_dstate.getWhiteSpaceFilter();
    }

    @Override
    public XDMCursor singleNode() {
        XDMNodeAdapterSingle xDMNodeAdapterSingle = new XDMNodeAdapterSingle(this.m_dstate, this.m_currentNode);
        xDMNodeAdapterSingle.resetIteration();
        return xDMNodeAdapterSingle;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public XDMCursor cloneWithReset() throws CloneNotSupportedException {
        XDMCursor xDMCursor = this.cloneXDMCursor();
        xDMCursor.resetIteration();
        return xDMCursor;
    }

    public XDMCursor includeSelf() {
        this.resetIteration();
        return this;
    }

    public boolean hasChildNodes() {
        if (this.m_currentNode == null) {
            return false;
        }
        short s = this.m_currentNode.getNodeType();
        if (s == 1 || XDMNodeAdapter.isRootNode(this.m_currentNode)) {
            return this.m_currentNode.hasChildNodes();
        }
        return false;
    }

    protected static boolean hasChildNodes(Node node) {
        short s = node.getNodeType();
        if (s == 1 || XDMNodeAdapter.isRootNode(node)) {
            return node.hasChildNodes();
        }
        return false;
    }

    @Override
    public XDMCursor getAttributeNode(String string, String string2) {
        if (this.m_currentNode instanceof Element) {
            Attr attr = ((Element)this.m_currentNode).getAttributeNodeNS(string, string2);
            if (!XDMNodeAdapter.isNamespace(attr)) {
                return new XDMNodeAdapterSingle(this.m_dstate, attr);
            }
            return null;
        }
        return null;
    }

    @Override
    public XDMCursor getDocumentRoot() {
        if (this.m_currentNode == null) {
            return null;
        }
        Node node = XDMNodeAdapter.getDocumentRoot(this.m_currentNode);
        XDMNodeAdapterCursorRoot xDMNodeAdapterCursorRoot = new XDMNodeAdapterCursorRoot(this.m_dstate, node);
        xDMNodeAdapterCursorRoot.resetIteration();
        return xDMNodeAdapterCursorRoot;
    }

    protected static boolean isSameNode(Node node, Node node2) {
        return node == node2 || node != null && node.isSameNode(node2);
    }

    protected static Node getParent(Node node) {
        if (XDMNodeAdapter.isRootNode(node)) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        Node node2 = node.getParentNode();
        return node2;
    }

    protected Node getNextSibling(Node node) {
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            short s = node2.getNodeType();
            if (s == 10) {
                node2 = node2.getNextSibling();
                continue;
            }
            if (s == 5) {
                node2 = node2.getNextSibling();
                continue;
            }
            if (XDMNodeAdapter.isTextNodeType(s) && this.textNodeShouldBeStripped(node2)) {
                node2 = node2.getNextSibling();
                continue;
            }
            if (!XDMNodeAdapter.isTextNode(node) || !XDMNodeAdapter.isTextNodeType(s)) break;
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    protected Node getPreviousSibling(Node node) {
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            return null;
        }
        while (node2 != null) {
            if (node2.getNodeType() == 10) {
                node2 = node2.getPreviousSibling();
                continue;
            }
            if (node2.getNodeType() == 5) {
                node2 = node2.getPreviousSibling();
                continue;
            }
            if (this.textNodeShouldBeStripped(node2)) {
                node2 = node2.getPreviousSibling();
                continue;
            }
            if (!XDMNodeAdapter.isTextNode(node2)) break;
            Node node3 = node2.getPreviousSibling();
            while (node3 != null && XDMNodeAdapter.isTextNode(node3)) {
                node2 = node3;
                node3 = node2.getPreviousSibling();
            }
            break block0;
        }
        return node2;
    }

    protected Node getNextNode(Node node) {
        if (node.getNodeType() == 2) {
            throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Unimplemented functionality in " + XDMNodeAdapter.class.getName()));
        }
        Node node2 = node;
        Node node3 = this.getFirstChild(node2);
        while (null == node3) {
            node3 = this.getNextSibling(node2);
            if (null != node3 || null != (node2 = XDMNodeAdapter.getParent(node2)) && !XDMNodeAdapter.isRootNode(node2)) continue;
            return null;
        }
        return node3;
    }

    protected Node getPrevNode(Node node) {
        if (node.getNodeType() == 2) {
            throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Unimplemented functionality in " + XDMNodeAdapter.class.getName()));
        }
        Node node2 = node;
        Node node3 = this.getPreviousSibling(node2);
        if (node3 != null) {
            Node node4 = this.getLastChild(node3);
            while (node4 != null) {
                node3 = node4;
                node4 = this.getLastChild(node3);
            }
            return node3;
        }
        return XDMNodeAdapter.getParent(node2);
    }

    protected static boolean isAncestor(Node node, Node node2) {
        Node node3 = XDMNodeAdapter.getParent(node);
        while (node3 != null && !node3.isSameNode(node2)) {
            node3 = XDMNodeAdapter.getParent(node3);
        }
        return node3 != null;
    }

    protected Node getFirstChild(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        short s = node2.getNodeType();
        switch (s) {
            case 1: 
            case 7: 
            case 8: {
                return node2;
            }
            case 3: 
            case 4: {
                if (this.shouldBeIgnored(node2)) {
                    return this.getNextSibling(node2);
                }
                return node2;
            }
            case 5: 
            case 10: {
                return this.getNextSibling(node2);
            }
        }
        XDMNodeAdapter.firstChildErr();
        return null;
    }

    private static void firstChildErr() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Unexpected type of the first child"));
    }

    protected Node getLastChild(Node node) {
        if (node.getNodeType() == 2) {
            return null;
        }
        Node node2 = node.getLastChild();
        if (node2 == null) {
            return null;
        }
        short s = node2.getNodeType();
        switch (s) {
            case 1: 
            case 7: 
            case 8: {
                return node2;
            }
            case 3: 
            case 4: {
                if (this.shouldBeIgnored(node2)) {
                    return this.getPreviousSibling(node2);
                }
                Node node3 = node2.getPreviousSibling();
                if (XDMNodeAdapter.isTextNode(node3)) {
                    return this.getPreviousSibling(node2);
                }
                return node2;
            }
            case 5: 
            case 10: {
                return this.getPreviousSibling(node2);
            }
        }
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Unexpected type of the first child"));
    }

    protected static Node getDocumentRoot(Node node) {
        Node node2 = null;
        if (XDMNodeAdapter.isRootNode(node)) {
            node2 = node;
        } else {
            Node node3;
            for (node3 = XDMNodeAdapter.getParent(node); node3 != null && !XDMNodeAdapter.isRootNode(node3); node3 = node3.getParentNode()) {
            }
            node2 = node3;
        }
        return node2;
    }

    public abstract XDMCursor getIterationRoot();

    @Override
    public abstract XDMCursor newContext(XDMCursor var1, Object var2, boolean var3);

    @Override
    public final XDMCursor newContext(XDMCursor xDMCursor) {
        return this.newContext(xDMCursor, null, true);
    }

    @Override
    public void resetIteration() {
        this.nextNode();
    }

    @Override
    public abstract boolean nextNode();

    @Override
    public void setShouldCacheNodes() {
    }

    @Override
    public abstract int getCurrentPos();

    @Override
    public abstract boolean setCurrentPos(int var1);

    @Override
    public abstract int getLength();

    @Override
    public boolean setDocOrdered() {
        return true;
    }

    @Override
    public boolean setDocOrderedUnique() {
        return true;
    }

    @Override
    public boolean isDocOrdered() {
        return true;
    }

    @Override
    public boolean isUniqueNodes() {
        return true;
    }

    @Override
    public abstract int getAxis();

    @Override
    public XDMCursor getElementById(String string) {
        Document document = this.m_currentNode.getOwnerDocument() == null ? (Document)this.m_currentNode : this.m_currentNode.getOwnerDocument();
        Element element = document.getElementById(string);
        return new XDMNodeAdapterSingle(this.m_dstate, element);
    }

    @Override
    public XDMCursor getXDMCursorFromNode(Node node) {
        return new XDMNodeAdapterSingle(this.m_dstate, node);
    }

    public XDMTreeWalker getTreeWalker() {
        XDMNodeAdapterTreeWalker xDMNodeAdapterTreeWalker = new XDMNodeAdapterTreeWalker(this.m_dstate, this.m_currentNode);
        return xDMNodeAdapterTreeWalker;
    }

    protected static final boolean isElementContentWhitespace(Node node) {
        if (XDMNodeAdapter.isTextNode(node)) {
            String string = node.getNodeValue();
            int n = string.length();
            block3: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c > ' ') {
                    return false;
                }
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean textNodeShouldBeStripped(Node node) {
        if (XDMNodeAdapter.isTextNode(node)) {
            return this.shouldBeIgnored(node);
        }
        return false;
    }

    private boolean shouldBeIgnored(Node node) {
        XDMWSFilter xDMWSFilter = this.m_dstate.getWhiteSpaceFilter();
        if (xDMWSFilter != null) {
            return this.filterText(xDMWSFilter, node);
        }
        return false;
    }

    private boolean filterText(XDMWSFilter xDMWSFilter, Node node) {
        if (XDMNodeAdapter.isElementContentWhitespace(node)) {
            Node node2 = node.getParentNode();
            if (!(node2 instanceof Element)) {
                return false;
            }
            XDMNodeAdapterSingle xDMNodeAdapterSingle = new XDMNodeAdapterSingle(this.m_dstate, node2);
            short s = xDMWSFilter.getShouldStripSpace(xDMNodeAdapterSingle);
            boolean bl = true;
            switch (s) {
                case 1: {
                    bl = false;
                    break;
                }
                case 2: {
                    bl = true;
                    break;
                }
                case 3: {
                    bl = false;
                    break;
                }
                default: {
                    throw new RuntimeException(XMLMessages.createXMLMessage("ER_UNKNOWN_RESULT_STRIPSPACE", new Object[0]));
                }
            }
            return bl;
        }
        return false;
    }

    protected final void wholeText(Text text, StringBuffer stringBuffer) {
        if (!this.shouldBeIgnored(text)) {
            stringBuffer.append(text.getNodeValue());
        }
        for (Node node = text.getNextSibling(); node != null && XDMNodeAdapter.isTextNode(node); node = node.getNextSibling()) {
            if (this.shouldBeIgnored(node)) continue;
            stringBuffer.append(node.getNodeValue());
        }
    }

    protected static final boolean isRootNode(Node node) {
        short s = node.getNodeType();
        return s == 11 || s == 9;
    }

    protected static final boolean isTextNode(Node node) {
        return XDMNodeAdapter.isTextNodeType(node.getNodeType());
    }

    protected static final boolean isTextNodeType(short s) {
        return s == 3 || s == 4;
    }

    public static String getLocalName(Node node) {
        String string;
        short s;
        String string2 = node.getLocalName();
        if (string2 == null && ((s = node.getNodeType()) == 2 || s == 1) && (string = node.getNodeName()) != null) {
            int n = string.lastIndexOf(58);
            string2 = n > 0 ? string.substring(n + 1) : string;
        }
        return string2;
    }

    public String getNodeData(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getNodeData(node, stringBuffer);
        return stringBuffer.length() > 0 ? stringBuffer.toString() : "";
    }

    public void getNodeData(Node node, StringBuffer stringBuffer) {
        block0 : switch (node.getNodeType()) {
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    this.getNodeData(nodeList.item(i), stringBuffer);
                }
                break;
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1) continue;
                    this.getNodeData(node2, stringBuffer);
                    break block0;
                }
                break;
            }
            case 1: {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    short s = node3.getNodeType();
                    if (s != 8 && s != 7 && s != 5) {
                        this.getNodeData(node3, stringBuffer);
                    }
                    if (XDMNodeAdapter.isTextNode(node3)) {
                        Node node4;
                        for (node4 = node3.getNextSibling(); node4 != null && XDMNodeAdapter.isTextNode(node4); node4 = node4.getNextSibling()) {
                        }
                        node3 = node4;
                        continue;
                    }
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 3: 
            case 4: {
                this.wholeText((Text)node, stringBuffer);
                break;
            }
            case 2: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
            case 7: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
            case 8: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
        }
    }

    @Override
    public XMLString getStringValue() {
        if (null != this.m_currentNode) {
            return new XMLStringDefault(this.getNodeData(this.m_currentNode));
        }
        return null;
    }

    @Override
    public String getStringValueX() {
        String string = "";
        if (null != this.m_currentNode) {
            string = this.getNodeData(this.m_currentNode);
        }
        return string == null ? "" : string;
    }

    @Override
    public int copyStringValue(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        this.getNodeData(this.m_currentNode, stringBuffer);
        int n3 = stringBuffer.length();
        if (n3 > n2) {
            return -n3;
        }
        stringBuffer.getChars(0, stringBuffer.length(), cArray, n);
        return n3;
    }

    @Override
    public int getExpandedTypeID() {
        if (this.m_currentNode == null) {
            return -1;
        }
        return this.getExpandedTypeID(this.m_currentNode);
    }

    @Override
    public int getExpandedTypeID(String string, String string2, int n) {
        return this.m_dstate.getExpandedTypeID(string, string2, n, false);
    }

    protected int getExpandedTypeID(Node node) {
        if (XDMNodeAdapter.isNamespace(node)) {
            String string = null;
            String string2 = XDMNodeAdapter.getLocalName(node);
            string = "xmlns".equals(string2) ? "" : string2;
            return this.m_dstate.getExpandedTypeID("", string, 13, false);
        }
        return this.m_dstate.getExpandedTypeID(node.getNamespaceURI(), XDMNodeAdapter.getLocalName(node), this.getNodeType(), false);
    }

    @Override
    public boolean expandedTypeIs(int n) {
        return this.expandedTypeIs(this.m_currentNode, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchesExpandedTypeOf(XDMNode xDMNode) {
        int n;
        if (!(xDMNode instanceof XDMNodeAdapter)) {
            return this.expandedTypeIs(xDMNode.getExpandedTypeID());
        }
        Node node = this.m_currentNode;
        Node node2 = ((XDMNodeAdapter)xDMNode).m_currentNode;
        if (node == null) return false;
        int n2 = this.getNodeType(node);
        if (n2 != (n = this.getNodeType(node2))) return false;
        if (n == 1 || n == 2) {
            String string;
            String string2 = XDMNodeAdapter.getLocalName(node);
            if (!string2.equals(string = XDMNodeAdapter.getLocalName(node2))) return false;
            String string3 = node.getNamespaceURI();
            String string4 = node2.getNamespaceURI();
            if (string4 == string3) {
                return true;
            }
            string4 = string4 != null ? string4 : "";
            string3 = string3 != null ? string3 : "";
            return string3.equals(string4);
        }
        if (n != 13) return true;
        String string = XDMNodeAdapter.getLocalName(node);
        if (this.getExpandedTypeID("", "xmlns".equals(string) ? "" : string, 13) != xDMNode.getExpandedTypeID()) return false;
        return true;
    }

    @Override
    public boolean matchesExpandedType(int n, short s, String string, String string2) {
        int n2;
        Node node = this.m_currentNode;
        if (node != null && (n2 = this.getNodeType(node)) == s) {
            if (s == 1 || s == 2) {
                String string3 = XDMNodeAdapter.getLocalName(node);
                if (string3.equals(string)) {
                    String string4 = node.getNamespaceURI();
                    if (string2 == string4) {
                        return true;
                    }
                    string2 = string2 != null ? string2 : "";
                    string4 = string4 != null ? string4 : "";
                    return string4.equals(string2);
                }
            } else {
                if (s == 13) {
                    String string5 = XDMNodeAdapter.getLocalName(node);
                    return this.getExpandedTypeID("", "xmlns".equals(string5) ? "" : string5, 13) == n;
                }
                return true;
            }
        }
        return false;
    }

    protected boolean expandedTypeIs(Node node, int n) {
        if (node != null) {
            short s = this.m_dstate.getType(n);
            int n2 = this.getNodeType(node);
            if (n2 == s) {
                if (s == 1 || s == 2) {
                    String string = XDMNodeAdapter.getLocalName(node);
                    if (string.equals(this.m_dstate.getLocalName(n))) {
                        String string2 = node.getNamespaceURI();
                        String string3 = this.m_dstate.getNamespace(n);
                        if (string3 == string2) {
                            return true;
                        }
                        string3 = string3 != null ? string3 : "";
                        string2 = string2 != null ? string2 : "";
                        return string2.equals(string3);
                    }
                } else {
                    if (s == 13) {
                        String string = XDMNodeAdapter.getLocalName(node);
                        return this.getExpandedTypeID("", "xmlns".equals(string) ? "" : string, 13) == n;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getLocalNameFromExpandedNameID(int n) {
        return this.m_dstate.getLocalName(n);
    }

    @Override
    public String getNamespaceFromExpandedNameID(int n) {
        return this.m_dstate.getNamespace(n);
    }

    @Override
    public String getNodeName() {
        if (this.m_currentNode != null) {
            return this.m_currentNode.getNodeName();
        }
        return null;
    }

    @Override
    public String getNodeNameX() {
        if (this.m_currentNode == null) {
            return null;
        }
        short s = this.m_currentNode.getNodeType();
        String string = null;
        switch (s) {
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "";
                break;
            }
            case 1: 
            case 7: {
                string = this.m_currentNode.getNodeName();
                break;
            }
            case 2: {
                if (XDMNodeAdapter.isNamespace(this.m_currentNode)) {
                    string = this.getLocalName();
                    if (!"xmlns".equals(string)) break;
                    string = "";
                    break;
                }
                string = this.m_currentNode.getNodeName();
                break;
            }
            default: {
                throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Unhandled type of a node"));
            }
        }
        return string;
    }

    @Override
    public String getLocalName() {
        String string;
        if (this.m_currentNode == null) {
            return null;
        }
        short s = this.m_currentNode.getNodeType();
        if (s == 7) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)this.m_currentNode;
            string = processingInstruction.getTarget();
        } else if (s == 9 || s == 8 || s == 3) {
            string = "";
        } else {
            string = XDMNodeAdapter.getLocalName(this.m_currentNode);
            if ("xmlns".equals(string)) {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getPrefix() {
        if (this.m_currentNode == null) {
            return null;
        }
        if (this.m_currentNode.getNodeType() == 2 && XDMNodeAdapter.isNamespace(this.m_currentNode)) {
            return "";
        }
        String string = this.m_currentNode.getPrefix();
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public String getNamespaceURI() {
        if (XDMNodeAdapter.isNamespace(this.m_currentNode)) {
            return "";
        }
        if (this.m_currentNode == null) {
            return "";
        }
        String string = this.m_currentNode.getNamespaceURI();
        return null != string ? string : "";
    }

    @Override
    public String getNodeValue() {
        if (this.m_currentNode == null) {
            return null;
        }
        return this.m_currentNode.getNodeValue();
    }

    @Override
    public int copyNodeValue(char[] cArray, int n, int n2) {
        String string = this.m_currentNode.getNodeValue();
        int n3 = string.length();
        if (n3 > n2) {
            return -n3;
        }
        string.getChars(0, n3, cArray, n);
        return n3;
    }

    @Override
    public int getNodeType() {
        return this.getNodeType(this.m_currentNode);
    }

    protected int getNodeType(Node node) {
        if (null == node) {
            return -1;
        }
        short s = node.getNodeType();
        if (s == 3) {
            return 3;
        }
        if (s == 1) {
            return 1;
        }
        if (s == 2) {
            if (XDMNodeAdapter.isNamespace(node)) {
                return 13;
            }
            return 2;
        }
        if (s == 4) {
            return 3;
        }
        if (s == 11) {
            return 9;
        }
        return s;
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    @Override
    public String getDocumentBaseURI() {
        return this.m_dstate.getDocumentBaseURI();
    }

    @Override
    public void setDocumentBaseURI(String string) {
        this.m_dstate.setDocumentBaseURI(string);
    }

    @Override
    public String getDocumentSystemIdentifier() {
        return this.getDocumentBaseURI();
    }

    public String getDocumentEncoding() {
        return this.m_dstate.getOriginEncoding();
    }

    public String getDocumentStandalone() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    public String getDocumentVersion() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    public String getDocumentTypeDeclarationSystemIdentifier() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    public String getDocumentTypeDeclarationPublicIdentifier() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    @Override
    public String getUnparsedEntityURI(String string) {
        if (this.m_currentNode == null) {
            return null;
        }
        Node node = XDMNodeAdapter.getDocumentRoot(this.m_currentNode);
        if (node.getNodeType() == 9) {
            DocumentType documentType = ((Document)node).getDoctype();
            if (documentType == null) {
                return "";
            }
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (namedNodeMap == null) {
                return "";
            }
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Entity entity = (Entity)namedNodeMap.item(i);
                String string2 = entity.getNodeName();
                if (!string2.equals(string)) continue;
                return entity.getSystemId();
            }
            return "";
        }
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    @Override
    public String getUnparsedEntityPublicID(String string) {
        if (this.m_currentNode == null) {
            return null;
        }
        Node node = XDMNodeAdapter.getDocumentRoot(this.m_currentNode);
        if (node.getNodeType() == 9) {
            DocumentType documentType = ((Document)node).getDoctype();
            if (documentType == null) {
                return "";
            }
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (namedNodeMap == null) {
                return "";
            }
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Entity entity = (Entity)namedNodeMap.item(i);
                String string2 = entity.getNodeName();
                if (!string2.equals(string)) continue;
                return entity.getPublicId();
            }
            return "";
        }
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    public boolean supportsPreStripping() {
        return false;
    }

    @Override
    public boolean isSameNode(XDMNode xDMNode) {
        if (xDMNode instanceof XDMNodeAdapter) {
            boolean bl = ((XDMNodeAdapter)xDMNode).m_currentNode.isSameNode(this.m_currentNode);
            return bl;
        }
        if (xDMNode instanceof XDMCursorProxyCursor) {
            boolean bl = ((XDMCursorProxyCursor)xDMNode).isSameNode(this);
            return bl;
        }
        return false;
    }

    @Override
    public boolean isInSameDocument(XDMNode xDMNode) {
        return xDMNode.getDocNumber() == this.getDocNumber();
    }

    @Override
    public int getDocNumber() {
        Node node = this.m_currentNode;
        if (node instanceof XDMNode) {
            return ((XDMNode)((Object)node)).getDocNumber();
        }
        return this.m_dstate.getDocumentNumber();
    }

    @Override
    public boolean isEmpty() {
        return this.m_currentNode == null;
    }

    @Override
    public int relativeDocOrder(XDMNode xDMNode) {
        int n = this.getDocNumber() - xDMNode.getDocNumber();
        if (n != 0) {
            return n;
        }
        XDMNode xDMNode2 = xDMNode;
        if (xDMNode2 instanceof XDMCursorProxyCursor) {
            xDMNode2 = ((XDMCursorProxyCursor)xDMNode)._internal_getInnermostXDMNode();
        }
        if (xDMNode2 instanceof XDMNodeAdapter) {
            Node node = ((XDMNodeAdapter)xDMNode2).m_currentNode;
            if (this.m_currentNode == node) {
                return 0;
            }
            if (this.m_currentNode instanceof Node) {
                if (XDMNodeAdapter.isNamespace(this.m_currentNode)) {
                    if (XDMNodeAdapter.isNamespace(node)) {
                        Element element;
                        Element element2 = ((Attr)this.m_currentNode).getOwnerElement();
                        if (XDMNodeAdapter.isSameNode(element2, element = ((Attr)node).getOwnerElement())) {
                            return XDMNodeAdapter.getLocalName(this.m_currentNode).compareTo(XDMNodeAdapter.getLocalName(node));
                        }
                        short s = element2.compareDocumentPosition(element);
                        return XDMNodeAdapter.convertRelativeOrder(s);
                    }
                    if (XDMNodeAdapter.isAttribute(node)) {
                        Element element = ((Attr)this.m_currentNode).getOwnerElement();
                        if (XDMNodeAdapter.isAttribute(node)) {
                            Element element3 = ((Attr)node).getOwnerElement();
                            if (XDMNodeAdapter.isSameNode(element, element3)) {
                                return -1;
                            }
                            short s = element.compareDocumentPosition(element3);
                            return XDMNodeAdapter.convertRelativeOrder(s);
                        }
                        short s = element.compareDocumentPosition(node);
                        return XDMNodeAdapter.convertRelativeOrder(s);
                    }
                } else if (XDMNodeAdapter.isNamespace(node)) {
                    Element element = ((Attr)node).getOwnerElement();
                    if (XDMNodeAdapter.isAttribute(this.m_currentNode)) {
                        Element element4 = ((Attr)this.m_currentNode).getOwnerElement();
                        if (XDMNodeAdapter.isSameNode(element4, element)) {
                            return 1;
                        }
                        short s = element4.compareDocumentPosition(element);
                        return XDMNodeAdapter.convertRelativeOrder(s);
                    }
                    short s = this.m_currentNode.compareDocumentPosition(element);
                    return XDMNodeAdapter.convertRelativeOrder(s);
                }
                short s = this.m_currentNode.compareDocumentPosition(node);
                return XDMNodeAdapter.convertRelativeOrder(s);
            }
        }
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    private static int convertRelativeOrder(short s) {
        if ((s & 1) > 0) {
            return 0;
        }
        if ((s & 2) > 0) {
            return 1;
        }
        if ((s & 4) > 0) {
            return -1;
        }
        return 0;
    }

    public boolean isWhitespaceInElementContent() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    public boolean isDocumentAllDeclarationsProcessed() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    public boolean isAttributeSpecified() {
        throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Not implemented"));
    }

    @Override
    public void dispatchCharactersEvents(ContentHandler contentHandler, boolean bl) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchToEvents(ContentHandler contentHandler) throws SAXException {
        if (null == this.m_currentNode) {
            return;
        }
        Node node = this.m_currentNode;
        TreeWalker treeWalker = new TreeWalker(null);
        treeWalker.setContentHandler(contentHandler);
        try {
            treeWalker.traverse(node);
        }
        finally {
            treeWalker.setContentHandler(null);
        }
    }

    @Override
    public Node getNode() {
        return this.m_currentNode;
    }

    @Override
    public SourceLocator getSourceLocator() {
        return null;
    }

    @Override
    public QName getSchemaTypeName() {
        if (this.m_currentNode instanceof ItemPSVI) {
            XSTypeDefinition xSTypeDefinition = ((ItemPSVI)((Object)this.m_currentNode)).getTypeDefinition();
            if (xSTypeDefinition == null) {
                int n = this.getNodeType();
                if (n == 1) {
                    return DEFELEMENTTYPENAME;
                }
                if (n == 2) {
                    return DEFATTRIBUTETYPENAME;
                }
                if (n == 3) {
                    return DEFTEXTTYPENAME;
                }
                return null;
            }
            if (xSTypeDefinition.getAnonymous()) {
                return null;
            }
            return new QName(xSTypeDefinition.getNamespace(), xSTypeDefinition.getName());
        }
        int n = this.getNodeType();
        if (n == 1) {
            return DEFELEMENTTYPENAME;
        }
        if (n == 2) {
            return DEFATTRIBUTETYPENAME;
        }
        if (n == 3) {
            return DEFTEXTTYPENAME;
        }
        return null;
    }

    @Override
    public String getSchemaTypeNamespace() {
        QName qName = this.getSchemaTypeName();
        if (qName == null) {
            return "";
        }
        return qName.getNamespaceURI();
    }

    @Override
    public String getSchemaTypeLocalName() {
        QName qName = this.getSchemaTypeName();
        if (qName == null) {
            return "";
        }
        return qName.getLocalPart();
    }

    @Override
    public boolean isNodeSchemaType(String string, String string2) {
        if (this.m_currentNode instanceof ItemPSVI) {
            XSTypeDefinition xSTypeDefinition = ((ItemPSVI)((Object)this.m_currentNode)).getTypeDefinition();
            if (xSTypeDefinition == null) {
                return false;
            }
            string = string != null && string.equals("") ? null : string;
            return xSTypeDefinition.derivedFrom(string, string2, (short)3);
        }
        return false;
    }

    @Override
    public Object getSchemaTypeObject() {
        if (this.m_currentNode instanceof ItemPSVI) {
            XSTypeDefinition xSTypeDefinition = ((ItemPSVI)((Object)this.m_currentNode)).getTypeDefinition();
            return xSTypeDefinition;
        }
        return null;
    }

    public boolean isNodeSchemaType(char[] cArray, char[] cArray2) {
        return this.isNodeSchemaType(new String(cArray), new String(cArray2));
    }

    @Override
    public int getBuiltInSimpleType() {
        XSTypeDefinition xSTypeDefinition;
        if (this.m_currentNode instanceof ItemPSVI && (xSTypeDefinition = ((ItemPSVI)((Object)this.m_currentNode)).getTypeDefinition()) != null && 16 == xSTypeDefinition.getTypeCategory()) {
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "boolean")) {
                return 17;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "double")) {
                return 3;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "float")) {
                return 2;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "integer")) {
                return 5;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "decimal")) {
                return 4;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "dayTimeDuration")) {
                return 8;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "untypedAtomic")) {
                return 7;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "duration")) {
                return 6;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "dateTime")) {
                return 9;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "time")) {
                return 10;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "date")) {
                return 11;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "gYearMonth")) {
                return 12;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "gYear")) {
                return 13;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "gMonthDay")) {
                return 14;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "gDay")) {
                return 15;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "gMonth")) {
                return 16;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "hexBinary")) {
                return 19;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "base64Binary")) {
                return 18;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "anyURI")) {
                return 20;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "QName")) {
                return 21;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "NOTATION")) {
                return 22;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "string")) {
                return 1;
            }
            if (this.isNodeSchemaType("http://www.w3.org/2001/XMLSchema", "untypedAtomic")) {
                return 0;
            }
            return 46;
        }
        return 45;
    }

    @Override
    public XDMSequence getTypedValue() {
        return null;
    }

    @Override
    public XDMCursor getAxisCursor(int n) {
        XDMNodeAdapter xDMNodeAdapter = null;
        switch (n) {
            case 13: {
                xDMNodeAdapter = new XDMNodeAdapterSingle(this.m_dstate, this.m_currentNode);
                break;
            }
            case 3: {
                xDMNodeAdapter = new XDMNodeAdapterCursorChild(this.m_dstate, this.m_currentNode);
                break;
            }
            case 10: {
                xDMNodeAdapter = new XDMNodeAdapterCursorParent(this.m_dstate, this.m_currentNode);
                break;
            }
            case 0: {
                xDMNodeAdapter = new XDMNodeAdapterCursorAncestor(this.m_dstate, this.m_currentNode);
                xDMNodeAdapter.setDocOrdered();
                break;
            }
            case 1: {
                xDMNodeAdapter = new XDMNodeAdapterCursorAncestorOrSelf(this.m_dstate, this.m_currentNode);
                xDMNodeAdapter.setDocOrdered();
                break;
            }
            case 2: {
                xDMNodeAdapter = new XDMNodeAdapterCursorAttribute(this.m_dstate, this.m_currentNode);
                break;
            }
            case 4: {
                xDMNodeAdapter = new XDMNodeAdapterCursorDescendant(this.m_dstate, this.m_currentNode);
                break;
            }
            case 5: {
                xDMNodeAdapter = new XDMNodeAdapterCursorDescendantOrSelf(this.m_dstate, this.m_currentNode);
                break;
            }
            case 6: {
                xDMNodeAdapter = new XDMNodeAdapterCursorFollowing(this.m_dstate, this.m_currentNode);
                break;
            }
            case 11: {
                xDMNodeAdapter = new XDMNodeAdapterCursorPreceding(this.m_dstate, this.m_currentNode);
                break;
            }
            case 7: {
                xDMNodeAdapter = new XDMNodeAdapterCursorFollowingSibling(this.m_dstate, this.m_currentNode);
                break;
            }
            case 12: {
                xDMNodeAdapter = new XDMNodeAdapterCursorPrecedingSibling(this.m_dstate, this.m_currentNode);
                break;
            }
            case 9: {
                xDMNodeAdapter = new XDMNodeAdapterCursorNamespace(this.m_dstate, this.m_currentNode);
                break;
            }
            case 19: {
                xDMNodeAdapter = new XDMNodeAdapterCursorRoot(this.m_dstate, this.m_currentNode);
                break;
            }
            case 22: {
                xDMNodeAdapter = new XDMNodeAdapterCursorNamespaceNoXMLDecl(this.m_dstate, this.m_currentNode);
                break;
            }
            case 99: {
                xDMNodeAdapter = new XDMNodeAdapterCursorNamespaceWithinElement(this.m_dstate, this.m_currentNode);
                break;
            }
            case 21: {
                Assert.assertNotImplemented();
            }
            default: {
                throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "The iterator for axis " + Axis.getName(n) + " is not implemented."));
            }
        }
        xDMNodeAdapter.resetIteration();
        return xDMNodeAdapter;
    }

    @Override
    public XDMCursor getTypedAxisCursor(int n, int n2) {
        XDMNodeAdapterCursorTypedProxy xDMNodeAdapterCursorTypedProxy = null;
        switch (n) {
            case 13: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterSingle(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 3: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorChild(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 10: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorParent(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 0: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorAncestor(this.m_dstate, this.m_currentNode), n2);
                xDMNodeAdapterCursorTypedProxy.setDocOrdered();
                break;
            }
            case 1: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorAncestorOrSelf(this.m_dstate, this.m_currentNode), n2);
                xDMNodeAdapterCursorTypedProxy.setDocOrdered();
                break;
            }
            case 2: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorAttribute(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 4: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorDescendant(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 5: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorDescendantOrSelf(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 6: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorFollowing(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 11: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorPreceding(this.m_dstate, this.m_currentNode), n2);
                xDMNodeAdapterCursorTypedProxy.setDocOrdered();
                break;
            }
            case 7: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorFollowingSibling(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 12: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorPrecedingSibling(this.m_dstate, this.m_currentNode), n2);
                xDMNodeAdapterCursorTypedProxy.setDocOrdered();
                break;
            }
            case 9: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorNamespace(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 19: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorRoot(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 22: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorNamespaceNoXMLDecl(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            case 99: {
                xDMNodeAdapterCursorTypedProxy = new XDMNodeAdapterCursorTypedProxy(this.m_dstate, new XDMNodeAdapterCursorNamespaceWithinElement(this.m_dstate, this.m_currentNode), n2);
                break;
            }
            default: {
                throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "The iterator for axis " + Axis.getName(n) + " is not implemented."));
            }
        }
        xDMNodeAdapterCursorTypedProxy.resetIteration();
        return xDMNodeAdapterCursorTypedProxy;
    }

    public void setCurrentNode(Node node) {
        this.m_currentNode = node;
    }

    @Override
    public XDMNode _internal_getInnermostXDMNode() {
        return this;
    }

    @Override
    public XDMManager getXDMManager() {
        try {
            return this.m_dstate.getManagerFactory().get(XDMManagerDOM.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getNamespaceURIID() {
        if (this.m_currentNode == null || !XDMNodeAdapter.isNamespace(this.m_currentNode)) {
            return -1;
        }
        int n = this.m_dstate.getExpandedTypeID(this.m_currentNode.getNodeValue(), "", 13, false);
        return n;
    }

    private static boolean isNamespace2(Node node) {
        String string = node.getPrefix();
        if (string == null) {
            return "xmlns".equals(node.getLocalName());
        }
        return "xmlns".equals(string);
    }

    protected static boolean isNamespace(Node node) {
        if (null == node) {
            return false;
        }
        return XDMNodeAdapter.isNamespace2(node);
    }

    private static boolean isAttribute(Node node) {
        return node != null && node.getNodeType() == 2;
    }

    protected Object getSimpleTypeValue() {
        if (this.m_currentNode instanceof ItemPSVI) {
            ItemPSVI itemPSVI = (ItemPSVI)((Object)this.m_currentNode);
            XSTypeDefinition xSTypeDefinition = itemPSVI.getTypeDefinition();
            if (xSTypeDefinition instanceof XSSimpleType) {
                return itemPSVI.getActualNormalizedValue();
            }
            throw new TypeError();
        }
        throw new TypeError();
    }

    @Override
    public byte[] getCurrentItemAsBase64Binary() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof ByteList) {
            ByteList byteList = (ByteList)object;
            byte[] byArray = new byte[byteList.getLength()];
            for (int i = 0; i < byteList.getLength(); ++i) {
                byArray[i] = byteList.item(i);
            }
            return byArray;
        }
        throw new TypeError();
    }

    @Override
    public boolean getCurrentItemAsBoolean() throws TypeError {
        Object object = this.getSimpleTypeValue();
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsDate() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[6];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getYears();
            nArray[1] = xSDateTime.getMonths();
            nArray[2] = xSDateTime.getDays();
            nArray[3] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[4] = xSDateTime.getTimeZoneHours();
            nArray[5] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsDateTime() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[10];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getYears();
            nArray[1] = xSDateTime.getMonths();
            nArray[2] = xSDateTime.getDays();
            nArray[3] = xSDateTime.getHours();
            nArray[4] = xSDateTime.getMinutes();
            nArray[5] = (int)Math.floor(xSDateTime.getSeconds());
            nArray[6] = (int)Math.floor(xSDateTime.getSeconds() % 1.0 * 1000.0);
            nArray[7] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[8] = xSDateTime.getTimeZoneHours();
            nArray[9] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsDay() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[4];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getDays();
            nArray[1] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[2] = xSDateTime.getTimeZoneHours();
            nArray[3] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsDayTimeDuration() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[5];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getDays();
            nArray[1] = xSDateTime.getHours();
            nArray[2] = xSDateTime.getMinutes();
            nArray[3] = (int)Math.floor(xSDateTime.getSeconds());
            nArray[4] = (int)Math.floor(xSDateTime.getSeconds() % 1.0 * 1000.0);
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public BigDecimal getCurrentItemAsDecimal() throws TypeError {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDecimal) {
            XSDecimal xSDecimal = (XSDecimal)object;
            return xSDecimal.getBigDecimal();
        }
        throw new TypeError();
    }

    @Override
    public double getCurrentItemAsDouble() throws TypeError {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDouble) {
            XSDouble xSDouble = (XSDouble)object;
            return xSDouble.getValue();
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsDuration() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[7];
            XSDateTime xSDateTime = (XSDateTime)object;
            Duration duration = xSDateTime.getDuration();
            nArray[0] = duration.getYears();
            nArray[1] = duration.getMonths();
            nArray[2] = duration.getDays();
            nArray[3] = duration.getHours();
            nArray[4] = duration.getMinutes();
            nArray[5] = (int)Math.floor(duration.getSeconds());
            nArray[6] = (int)Math.floor(duration.getSeconds() % 1 * 1000);
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public float getCurrentItemAsFloat() throws TypeError {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSFloat) {
            XSFloat xSFloat = (XSFloat)object;
            return xSFloat.getValue();
        }
        throw new TypeError();
    }

    @Override
    public byte[] getCurrentItemAsHexBinary() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof ByteList) {
            ByteList byteList = (ByteList)object;
            byte[] byArray = new byte[byteList.getLength()];
            for (int i = 0; i < byteList.getLength(); ++i) {
                byArray[i] = byteList.item(i);
            }
            return byArray;
        }
        throw new TypeError();
    }

    @Override
    public int getCurrentItemAsInt() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDecimal) {
            XSDecimal xSDecimal = (XSDecimal)object;
            return xSDecimal.getInt();
        }
        throw new TypeError();
    }

    @Override
    public BigInteger getCurrentItemAsInteger() throws TypeError {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDecimal) {
            XSDecimal xSDecimal = (XSDecimal)object;
            return xSDecimal.getBigInteger();
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsMonth() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[4];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getMonths();
            nArray[1] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[2] = xSDateTime.getTimeZoneHours();
            nArray[3] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsMonthDay() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[5];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getMonths();
            nArray[1] = xSDateTime.getDays();
            nArray[2] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[3] = xSDateTime.getTimeZoneHours();
            nArray[4] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public XDMNode getCurrentItemAsNode() throws TypeError {
        return this.singleNode();
    }

    @Override
    public QName getCurrentItemAsQName() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSQName) {
            return ((XSQName)object).getJAXPQName();
        }
        throw new TypeError();
    }

    @Override
    public QName getCurrentItemAsNotation() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSQName) {
            return ((XSQName)object).getJAXPQName();
        }
        throw new TypeError();
    }

    @Override
    public String getCurrentItemAsString() throws TypeError {
        return super.getCurrentItemAsString();
    }

    @Override
    public int[] getCurrentItemAsTime() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[7];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getHours();
            nArray[1] = xSDateTime.getMinutes();
            nArray[2] = (int)Math.floor(xSDateTime.getSeconds());
            nArray[3] = (int)Math.floor(xSDateTime.getSeconds() % 1.0 * 1000.0);
            nArray[4] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[5] = xSDateTime.getTimeZoneHours();
            nArray[6] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public XItem getCurrentItemAsTypedValue(ItemType itemType) throws TypeError {
        return super.getCurrentItemAsTypedValue(itemType);
    }

    @Override
    public URI getCurrentItemAsURI() {
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsYear() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[4];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getYears();
            nArray[1] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[2] = xSDateTime.getTimeZoneHours();
            nArray[3] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsYearMonth() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[5];
            XSDateTime xSDateTime = (XSDateTime)object;
            nArray[0] = xSDateTime.getYears();
            nArray[1] = xSDateTime.getMonths();
            nArray[2] = xSDateTime.hasTimeZone() ? 1 : 0;
            nArray[3] = xSDateTime.getTimeZoneHours();
            nArray[4] = xSDateTime.getTimeZoneMinutes();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public int[] getCurrentItemAsYearMonthDuration() {
        Object object = this.getSimpleTypeValue();
        if (object instanceof XSDateTime) {
            int[] nArray = new int[2];
            XSDateTime xSDateTime = (XSDateTime)object;
            Duration duration = xSDateTime.getDuration();
            nArray[0] = duration.getYears();
            nArray[1] = duration.getMonths();
            return nArray;
        }
        throw new TypeError();
    }

    @Override
    public ItemType getCurrentItemType() {
        return super.getCurrentItemType();
    }

    @Override
    public int typeMatches(ItemType itemType, int n) {
        return super.typeMatches(itemType, n);
    }

    @Override
    public boolean isNilled() {
        if (this.m_currentNode instanceof ElementPSVI) {
            ElementPSVI elementPSVI = (ElementPSVI)((Object)this.m_currentNode);
            return elementPSVI.getNil();
        }
        return false;
    }
}

