/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.IQNameWrapper;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.ISequenceType;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.scontext.XStaticContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class FunctionDecl
extends TopLevelDecl {
    protected QName _name;
    protected TypeExpr _returnType;
    protected boolean _override = true;
    protected List _paramTypes;
    protected List _parameters = new ArrayList();
    protected boolean _hasDuplicate = false;
    boolean m_external;

    public FunctionDecl(int n) {
        super(n);
    }

    public FunctionDecl() {
        super(32);
    }

    public boolean hasParams() {
        return this._parameters.size() > 0;
    }

    public void addParameter(Param param) {
        this._parameters.add(param);
    }

    public List getParameters() {
        return this._parameters;
    }

    public Param lookupParam(QName qName) {
        for (int i = 0; i < this._parameters.size(); ++i) {
            Param param = (Param)this._parameters.get(i);
            if (!param.getQName().equals(qName)) continue;
            return param;
        }
        return null;
    }

    public void setQName(QName qName) {
        this._name = qName;
    }

    public QName getQName() {
        return this._name;
    }

    public boolean isExternal() {
        return this.m_external;
    }

    public int getArity() {
        return this._parameters.size();
    }

    public boolean isOverride() {
        return this._override;
    }

    public List getParamTypes() {
        return this._paramTypes;
    }

    public TypeExpr getResultType() {
        return this._returnType;
    }

    public void setResultType(TypeExpr typeExpr) {
        this._returnType = typeExpr;
    }

    private void setTypeFromParams() {
        if (this._paramTypes == null) {
            this._paramTypes = new ArrayList(this.getArity());
        }
        boolean bl = false;
        for (int i = 0; i < this._parameters.size(); ++i) {
            Node node = (Node)this._parameters.get(i);
            if (!(node instanceof Param)) continue;
            Param param = (Param)node;
            TypeExpr typeExpr = param.getType();
            if (typeExpr == null) {
                typeExpr = null;
            } else {
                bl = true;
            }
            this._paramTypes.add(typeExpr);
        }
        if (!bl) {
            this._paramTypes = null;
        }
    }

    public void setDuplicate(boolean bl) {
        this._hasDuplicate = bl;
    }

    public boolean isDuplicate() {
        return this._hasDuplicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parseContents(XSLTParser xSLTParser) {
        String string;
        Object object;
        String string2 = this.getAttribute("name");
        if (string2.length() > 0) {
            if (string2.indexOf(":") <= 0) {
                ASTMsg aSTMsg = new ASTMsg("MISSING_PREFIX_IN_ATTRIB", "name", "xsl:function", this);
                xSLTParser.reportError(3, aSTMsg);
                return;
            }
            object = xSLTParser.getQNameIgnoreDefaultNs(string2);
            string = ((QName)object).getNamespaceURI();
            if (xSLTParser.isReservedNamespace(string)) {
                ASTMsg aSTMsg = new ASTMsg("IN_RESERVED_NAMESPACE", "name", "xsl:function", this);
                xSLTParser.reportError(3, aSTMsg);
                return;
            }
            this.setQName(xSLTParser.getQNameIgnoreDefaultNs(string2));
        }
        if (((String)(object = this.getAttribute("as"))).length() > 0) {
            this._returnType = xSLTParser.parseSequenceTypeExpression(this, (String)object);
        }
        if ((string = this.getAttribute("override")).length() > 0) {
            if (string.trim().equalsIgnoreCase("yes")) {
                this._override = true;
            } else {
                if (!string.trim().equalsIgnoreCase("no")) {
                    ASTMsg aSTMsg = new ASTMsg("INVALID_YES_NO_VALUE", (Object)"override", (Expr)this);
                    xSLTParser.reportError(3, aSTMsg);
                    return;
                }
                this._override = false;
            }
        }
        this.parseChildren(xSLTParser);
        XStaticContext xStaticContext = xSLTParser.getStaticContext();
        FunctionDecl functionDecl = xStaticContext.lookupStylesheetFunction(this._name, this.getArity());
        if (functionDecl != null) {
            int n;
            int n2 = this.getImportPrecedence();
            if (n2 == (n = functionDecl.getImportPrecedence())) {
                functionDecl.setDuplicate(true);
                return;
            }
            if (n > n2 || !this._override) {
                return;
            }
            xStaticContext.removeStylesheetFunction(this._name, this.getArity());
        }
        if (this.getArity() > 0) {
            this.setTypeFromParams();
        }
        xStaticContext.addStylesheetFunction(this);
    }

    public int getParamCount() {
        return this._parameters.size();
    }

    public QName getParamName(int n) {
        Param param = (Param)this._parameters.get(n);
        return param.getQName();
    }

    public Param getParam(int n) {
        Param param = (Param)this._parameters.get(n);
        return param;
    }

    public TypeExpr getParamType(int n) {
        return null != this._paramTypes ? this._paramTypes.get(n) : null;
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        stringBuffer.append("declare function ").append(this.getString(this.getQName())).append("(");
        this.getParamsString(stringBuffer, bl, string);
        if (null != this._returnType) {
            stringBuffer.append(") as ");
            this._returnType.getXQueryString(stringBuffer, bl, string);
        }
        if (this.isExternal()) {
            stringBuffer.append(" external");
        } else {
            stringBuffer.append("\n" + string + "{\n" + string + " ");
            this.getXQueryStringForChildren(stringBuffer, bl, string);
            stringBuffer.append("\n" + string + "}" + string + " ");
        }
        stringBuffer.append("\r\r");
    }

    protected void getParamsString(StringBuffer stringBuffer, boolean bl, String string) {
        List list = this.getParameters();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            Param param = this.getParam(i);
            param.getXQueryString(stringBuffer, bl, string);
        }
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node, int n) {
        int n2 = node.getId();
        switch (n2) {
            case 191: {
                QName qName = ((IQNameWrapper)node).getQName();
                String string = qName.getNamespaceURI();
                if (string != null && string.length() > 0) {
                    if (!aSTBuildingContext.getStaticContext().isReservedNamespace(string)) {
                        this.setQName(qName);
                        break;
                    }
                    ASTMsg aSTMsg = new ASTMsg("IN_RESERVED_NAMESPACE", (Object)"xsl:function", (Expr)this);
                    aSTBuildingContext.reportError(3, aSTMsg);
                    return;
                }
                this.setQName(qName);
                return;
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                this.addChildrenOfUselessNode(aSTBuildingContext, node, n);
                break;
            }
            case 34: {
                Param param = (Param)node;
                this._parameters.add(0, param);
                break;
            }
            case 165: {
                ISequenceType iSequenceType = (ISequenceType)node;
                this._returnType = iSequenceType.getRealSeqType();
                break;
            }
            default: {
                SimpleNode simpleNode = this.reducedNode(aSTBuildingContext, (SimpleNode)node);
                super.jjtInsertChild(simpleNode, 0);
            }
        }
    }

    @Override
    public void jjtClose(ASTBuildingContext aSTBuildingContext) {
        super.jjtClose(aSTBuildingContext);
        XStaticContext xStaticContext = aSTBuildingContext.getStaticContext();
        FunctionDecl functionDecl = xStaticContext.lookupStylesheetFunction(this._name, this.getArity());
        if (functionDecl != null) {
            int n;
            int n2 = this.getImportPrecedence();
            if (n2 == (n = functionDecl.getImportPrecedence())) {
                functionDecl.setDuplicate(true);
                return;
            }
            if (n > n2 || !this._override) {
                return;
            }
            xStaticContext.removeStylesheetFunction(this._name, this.getArity());
        }
        if (this.getArity() > 0) {
            this.setTypeFromParams();
        }
        xStaticContext.addStylesheetFunction(this);
    }
}

