/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.ranges;

import com.ibm.rmi.util.ranges.FreeRange;
import com.ibm.rmi.util.ranges.RangeSetBuilderImpl;
import com.ibm.rmi.util.ranges.RangeSetHolder;
import java.util.Arrays;

public final class Ranges {
    public static final RangeSetHolder EMPTY = new EmptyRangeSetHolder();

    private Ranges() {
    }

    public static FreeRange buildRangeSet() {
        return new RangeSetBuilderImpl().and();
    }

    public static boolean contains(int[] nArray, int n, int n2) {
        int n3 = Ranges.compose(n, n2);
        int n4 = Arrays.binarySearch(nArray, n3);
        return n4 >= 0 || n4 % 2 == 0;
    }

    public static String stringify(int[] nArray) {
        return Ranges.stringifyRangeSet(nArray, nArray.length);
    }

    static int compose(int n, int n2) {
        return n << 16 | 0xFFFF & n2;
    }

    static String stringifyBound(int n, int n2) {
        return "(" + Integer.toHexString(0xFFFF & n) + ":" + (0xFFFF & n2) + ")";
    }

    static String stringifyRangeSet(int[] nArray, int n) {
        String string = "{";
        if ((n = Math.min(n, nArray.length)) > 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                string = string + Ranges.stringifyBound(n2 >>> 16, n2);
                if (i % 2 == 0) {
                    string = string + "->";
                    continue;
                }
                if (i + 1 == n) continue;
                string = string + ", ";
            }
        }
        string = string + "}";
        return string;
    }

    static class EmptyRangeSetHolder
    implements RangeSetHolder {
        static int[] EMPTY_INT_ARRAY = new int[0];

        EmptyRangeSetHolder() {
        }

        @Override
        public int[] getRangeSet() {
            return EMPTY_INT_ARRAY;
        }

        public String toString() {
            return "{}";
        }
    }
}

