/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.rmi.ras.Utility;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ListenerThread
extends com.ibm.CORBA.transport.ListenerThread {
    private static final String CLASS = ListenerThread.class.getName();
    protected static final int MAX_CLEANUP_RETRIES = 5;
    protected ServerSocket serverSocket;
    protected int acceptTimeout;
    protected ConnectionTable connectionTable;
    protected boolean bKeepAlive;
    protected TransportBase transportBase = null;
    static int instanceCounter = 0;
    int thisInstanceNumber;

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, String string, TransportBase transportBase) {
        this(connectionTable, serverSocket, 0, false, string, transportBase);
    }

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, int n, boolean bl, String string, TransportBase transportBase) {
        super(string);
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINEST, "serverSocket=" + serverSocket + " timeout=" + n, CLASS, "<init>:106");
        }
        this.serverSocket = serverSocket;
        this.acceptTimeout = n;
        this.bKeepAlive = bl;
        this.connectionTable = connectionTable;
        this.thisInstanceNumber = instanceCounter++;
        this.transportBase = transportBase;
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "<init>:117");
        }
    }

    @Override
    public void run() {
        if (Trc.enabled(3)) {
            Trc.begin(Trc.FINEST, CLASS, "run:125");
        }
        final String string = "LT=" + this.thisInstanceNumber + ":" + this.getName();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ListenerThread.this.setName(string);
                return null;
            }
        });
        int n = 0;
        try {
            this.serverSocket.setSoTimeout(this.acceptTimeout);
        }
        catch (SocketException socketException) {
            Trc.ffdc(socketException, CLASS, "run:157");
        }
        while (true) {
            try {
                while (true) {
                    Socket socket;
                    block16: {
                        socket = this.serverSocket.accept();
                        if (Trc.enabled()) {
                            Trc.warn(Utility.getMessage("ListenerThread.acceptSocket", socket.toString()), CLASS, "run:176");
                        }
                        try {
                            socket.setTcpNoDelay(true);
                            if (this.bKeepAlive) {
                                socket.setKeepAlive(true);
                            }
                        }
                        catch (Exception exception) {
                            if (!Trc.enabled()) break block16;
                            Trc.warn(exception.toString(), CLASS, "run:187");
                        }
                    }
                    this.transportBase.createTransportConnection(socket, this);
                    n = 0;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.isShutdownPending()) continue;
                if (!Trc.enabled()) break;
                Trc.warn("accept interrupted with shutdown pending", CLASS, "run:202");
            }
            catch (SocketException socketException) {
                if (this.isShutdownPending()) {
                    if (!Trc.enabled()) break;
                    Trc.warn(socketException.getMessage() + " with shutdown pending", CLASS, "run:213");
                    break;
                }
                Trc.ffdc(socketException, CLASS, "run:217");
                if (n == 5 || !this.connectionTable.cleanUp()) continue;
                ++n;
                continue;
            }
            catch (Throwable throwable) {
                Trc.ffdc(throwable, CLASS, "run:238");
                continue;
            }
            break;
        }
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINER, "ListenerThread shutting down", CLASS, "run:244");
        }
        this.connectionTable.cleanUp();
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "run:253");
        }
    }

    @Override
    public void setShutdownPending(boolean bl) {
        super.setShutdownPending(bl);
        if (bl) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                Trc.ffdc(iOException, CLASS, "setShutdownPending:269");
            }
        }
    }
}

