/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class KRBSafeBody {
    public byte[] userData;
    public KerberosTime timestamp;
    public Integer usec;
    public Integer seqNumber;
    public HostAddress sAddress;
    public HostAddress rAddress;

    public KRBSafeBody(byte[] byArray, KerberosTime kerberosTime, Integer n2, Integer n3, HostAddress hostAddress, HostAddress hostAddress2) {
        this.userData = byArray;
        this.timestamp = kerberosTime;
        this.usec = n2;
        this.seqNumber = n3;
        this.sAddress = hostAddress;
        this.rAddress = hostAddress2;
    }

    public KRBSafeBody(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2;
        block12: {
            block11: {
                if (derValue.getTag() != 48) {
                    throw new Asn1Exception(906);
                }
                derValue2 = derValue.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) != 0) break block11;
                this.userData = derValue2.getData().getOctetString();
                break block12;
            }
            throw new Asn1Exception(906);
        }
        this.timestamp = KerberosTime.parse(derValue.getData(), (byte)1, true);
        if ((derValue.getData().peekByte() & 0x1F) == 2) {
            derValue2 = derValue.getData().getDerValue();
            this.usec = new Integer(derValue2.getData().getBigInteger().intValue());
        }
        if ((derValue.getData().peekByte() & 0x1F) == 3) {
            derValue2 = derValue.getData().getDerValue();
            this.seqNumber = new Integer(derValue2.getData().getBigInteger().intValue());
        }
        this.sAddress = HostAddress.parse(derValue.getData(), (byte)4, false);
        if (derValue.getData().available() > 0) {
            this.rAddress = HostAddress.parse(derValue.getData(), (byte)5, true);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.userData);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        if (this.timestamp != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.timestamp.asn1Encode());
        }
        if (this.usec != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.usec.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        }
        if (this.seqNumber != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.seqNumber);
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream2);
        }
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.sAddress.asn1Encode());
        if (this.rAddress != null) {
            derOutputStream2 = new DerOutputStream();
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KRBSafeBody parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new KRBSafeBody(derValue2);
    }
}

