/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.DestroyFailedException;

final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable {
    static final long serialVersionUID = 4979297236007557055L;
    private BigInteger version = BigInteger.ZERO;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private AlgorithmParameterSpec keyParams;
    private RSAUtil.KeyType type;
    private static final String[] z;

    public static RSAPrivateCrtKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(byArray);
        return rSAPrivateCrtKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static java.security.interfaces.RSAPrivateKey newKey(RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId((RSAUtil.KeyType)keyType, (AlgorithmParameterSpec)algorithmParameterSpec);
        if (bigInteger2.signum() != 0 && bigInteger4.signum() != 0 && bigInteger5.signum() != 0 && bigInteger6.signum() != 0 && bigInteger7.signum() != 0 && bigInteger8.signum() != 0) {
            return new RSAPrivateCrtKey(algorithmId, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        }
        return new RSAPrivateKey(algorithmId, bigInteger, bigInteger3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RSAPrivateCrtKey(byte[] byArray) throws InvalidKeyException {
        if (byArray == null) throw new InvalidKeyException(z[8]);
        if (byArray.length == 0) {
            throw new InvalidKeyException(z[8]);
        }
        try {
            this.decode(byArray);
            RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
            return;
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception);
        }
    }

    public RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.type, (AlgorithmParameterSpec)this.keyParams);
        this.rsaPrivateCrtKey(algorithmId, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public RSAPrivateCrtKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.rsaPrivateCrtKey(algorithmId, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        byte[] byArray = bigInteger.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger.toByteArray();
        byte[] byArray2 = byArray;
        byte[] byArray3 = bigInteger2.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger2.toByteArray();
        byte[] byArray4 = byArray3;
        byte[] byArray5 = bigInteger3.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger3.toByteArray();
        byte[] byArray6 = byArray5;
        byte[] byArray7 = bigInteger4.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger4.toByteArray();
        byte[] byArray8 = byArray7;
        byte[] byArray9 = bigInteger5.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger5.toByteArray();
        byte[] byArray10 = byArray9;
        byte[] byArray11 = bigInteger6.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger6.toByteArray();
        byte[] byArray12 = byArray11;
        byte[] byArray13 = bigInteger7.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger7.toByteArray();
        byte[] byArray14 = byArray13;
        byte[] byArray15 = bigInteger8.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger8.toByteArray();
        byte[] byArray16 = byArray15;
        byte[][] byArrayArray = new byte[][]{byArray2, byArray4, byArray6, byArray8, byArray10, byArray12, byArray14, byArray16};
        try {
            RSAPrivateCrtKey.a(byArrayArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[6] + exception.getMessage());
        }
        this.modulus = new BigInteger(byArrayArray[0]);
        this.privateExponent = new BigInteger(byArrayArray[1]);
        this.publicExponent = new BigInteger(byArrayArray[2]);
        this.primeP = new BigInteger(byArrayArray[3]);
        this.primeQ = new BigInteger(byArrayArray[4]);
        this.primeExponentP = new BigInteger(byArrayArray[5]);
        this.primeExponentQ = new BigInteger(byArrayArray[6]);
        this.crtCoefficient = new BigInteger(byArrayArray[7]);
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
        this.algid = algorithmId;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.version.toByteArray()), new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray()), new DerValue(2, this.privateExponent.toByteArray()), new DerValue(2, this.primeP.toByteArray()), new DerValue(2, this.primeQ.toByteArray()), new DerValue(2, this.primeExponentP.toByteArray()), new DerValue(2, this.primeExponentQ.toByteArray()), new DerValue(2, this.crtCoefficient.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[7] + iOException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.version = derValue.getData().getInteger();
            if (this.version.intValue() != 0) {
                throw new IOException(z[4]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                System.out.println(z[3]);
                throw new IOException(z[2]);
            }
        }
        catch (Exception exception) {
            throw new IOException(z[1] + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(byte[][] byArray) {
        int n2;
        BigInteger[] bigIntegerArray = new BigInteger[8];
        for (n2 = 0; n2 < 8; ++n2) {
            if (byArray[n2] == null) continue;
            bigIntegerArray[n2] = new BigInteger(1, byArray[n2]);
        }
        if (bigIntegerArray[3].compareTo(bigIntegerArray[4]) < 0) {
            BigInteger bigInteger = bigIntegerArray[3];
            bigIntegerArray[3] = bigIntegerArray[4];
            bigIntegerArray[4] = bigInteger;
            bigInteger = bigIntegerArray[5];
            bigIntegerArray[5] = bigIntegerArray[6];
            bigIntegerArray[6] = bigInteger;
            bigIntegerArray[7] = null;
        }
        if (bigIntegerArray[7] == null) {
            bigIntegerArray[7] = bigIntegerArray[4].modInverse(bigIntegerArray[3]);
        }
        if (bigIntegerArray[0] == null) {
            bigIntegerArray[0] = bigIntegerArray[3].multiply(bigIntegerArray[4]);
        }
        if (bigIntegerArray[1] == null) {
            bigIntegerArray[1] = bigIntegerArray[2].modInverse(bigIntegerArray[3].subtract(BigInteger.ONE).multiply(bigIntegerArray[4].subtract(BigInteger.ONE)));
        }
        if (bigIntegerArray[5] == null) {
            bigIntegerArray[5] = bigIntegerArray[1].mod(bigIntegerArray[3].subtract(BigInteger.ONE));
        }
        if (bigIntegerArray[6] == null) {
            bigIntegerArray[6] = bigIntegerArray[1].mod(bigIntegerArray[4].subtract(BigInteger.ONE));
        }
        n2 = 0;
        while (n2 < 8) {
            byArray[n2] = bigIntegerArray[n2].toByteArray();
            ++n2;
        }
        return;
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    String a(byte[] byArray) {
        String string = z[0];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(string.charAt(n2 >> 4));
            stringBuffer.append(string.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new InvalidObjectException(z[5]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "NCd 'KDa+*\u001f\u00105wv\u0018";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                block19: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block19;
                    n5 = n5;
                    if (n5 <= n4) break block20;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 126;
                            break;
                        }
                        case 1: {
                            n6 = 114;
                            break;
                        }
                        case 2: {
                            n6 = 86;
                            break;
                        }
                        case 3: {
                            n6 = 19;
                            break;
                        }
                        default: {
                            n6 = 19;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "7\u001c r\u007f\u0017\u0016vxv\u0007R r\u007f\u000b\u0017v\u0019";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "7\u001c r\u007f\u0017\u0016vA@?\"$ze\u001f\u00063Pa\n93j3\u001b\u001c5|w\u0017\u001c1?3\u001a\u0013\"r3\u0011\u00043aa\u000b\u001c";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001b\n\"ar^\u00167gr^\u0013 rz\u0012\u00134\u007fv";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "(\u0017$`z\u0011\u001cv~f\r\u0006vqv^B";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ",!\u0017Ca\u0017\u00047gv=\u0000\"Xv\u0007R=vj\rR7av^\u001c9g3\u001a\u001b$vp\n\u001e/3w\u001b\u00013az\u001f\u001e?ir\u001c\u001e3";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "=\u001d#\u007fw^\u001c9g3\r\u0017\"3A-3vxv\u0007Hv";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001d\u001d#\u007fw^\u001c9g3:7\u00043v\u0010\u00119wvDR";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "3\u001b%`z\u0010\u0015vxv\u0007R3}p\u0011\u0016?}t";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

