/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.events.EventManager;
import com.ibm.j9ddr.vm29_00.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MemorySegmentPointer;
import java.util.NoSuchElementException;

public class GCSegmentIterator
extends GCIterator {
    private J9MemorySegmentPointer memorySegment;
    private long flags;

    protected GCSegmentIterator(J9MemorySegmentListPointer list, long flags) throws CorruptDataException {
        this.memorySegment = list.nextSegment();
        this.flags = flags;
    }

    public static GCSegmentIterator fromJ9MemorySegmentList(J9MemorySegmentListPointer list, long flags) throws CorruptDataException {
        return new GCSegmentIterator(list, flags);
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.memorySegment.notNull()) {
                if (this.memorySegment.type().allBitsIn(this.flags)) {
                    return true;
                }
                this.memorySegment = this.memorySegment.nextSegment();
            }
            return false;
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error checking segments", cde, true);
            return false;
        }
    }

    @Override
    public J9MemorySegmentPointer next() {
        try {
            if (this.hasNext()) {
                J9MemorySegmentPointer currentMemorySegment = this.memorySegment;
                this.memorySegment = this.memorySegment.nextSegment();
                return currentMemorySegment;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

