/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.SegmentsUtil;
import java.io.PrintStream;

public class DumpAllSegmentsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public DumpAllSegmentsCommand() {
        this.addCommand("dumpallsegments", "", "dump all segments in the VM");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            out.append(String.format("memorySegments - !j9memorysegmentlist 0x%s\n", Long.toHexString(vm.memorySegments().getAddress())));
            SegmentsUtil.dbgDumpSegmentList(out, vm.memorySegments());
            out.append(String.format("classMemorySegments - !j9memorysegmentlist 0x%s\n", Long.toHexString(vm.classMemorySegments().getAddress())));
            SegmentsUtil.dbgDumpSegmentList(out, vm.classMemorySegments());
            if (J9BuildFlags.J9VM_INTERP_NATIVE_SUPPORT) {
                if (!vm.jitConfig().isNull()) {
                    out.append(String.format("jit code segments - !j9memorysegmentlist 0x%s\n", Long.toHexString(vm.jitConfig().codeCacheList().getAddress())));
                    SegmentsUtil.dbgDumpJITCodeSegmentList(out, vm.jitConfig().codeCacheList());
                    out.append(String.format("jit data segments - !j9memorysegmentlist 0x%s\n", Long.toHexString(vm.jitConfig().dataCacheList().getAddress())));
                    SegmentsUtil.dbgDumpSegmentList(out, vm.jitConfig().dataCacheList());
                } else {
                    out.append("JIT not enabled\n");
                }
            }
            out.append(nl);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

