/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import java.io.PrintStream;

public class CPDescriptionCommand
extends Command {
    public CPDescriptionCommand() {
        this.addCommand("cpdescription", "<address>", "Dump the cpdescription for the J9ROMClass");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9ROMClassPointer romClass = J9ROMClassPointer.cast(address);
            U32Pointer cpDescription = J9ROMClassHelper.cpShapeDescription(romClass);
            long cpCount = romClass.romConstantPoolCount().longValue();
            long numberOfLongs = (cpCount + J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 - 1L) / J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            out.append("CP Shape Description:" + nl);
            long k = 0L;
            for (long i = 0L; i < numberOfLongs; ++i) {
                long descriptionLong = cpDescription.at(i).longValue();
                for (long j = 0L; j < J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 && k != cpCount; ++j, ++k) {
                    out.append("[" + k + "] = " + (int)(descriptionLong & J9ConstantPool.J9_CP_DESCRIPTION_MASK) + nl);
                    descriptionLong >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
                }
            }
            out.append(nl);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

