/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.logging.Logger;

public class FindVMTask
implements IBootstrapRunnable {
    private final Logger logger = CommandUtils.getLogger();
    private static final String J9VM_ADDRESS_PROPERTY = "com.ibm.j9ddr.vmaddr";

    @Override
    public void run(IVMData vmData, Object[] userData) {
        long[] passBackArray = (long[])userData[0];
        String vmAddressString = System.getProperty(J9VM_ADDRESS_PROPERTY);
        if (vmAddressString != null) {
            long address = 0L;
            try {
                address = vmAddressString.startsWith("0x") ? Long.parseLong(vmAddressString.substring(2), 16) : Long.parseLong(vmAddressString);
            }
            catch (NumberFormatException nfe) {
                this.logger.warning("System property com.ibm.j9ddr.vmaddr does not contain a valid pointer address, found: " + vmAddressString);
                throw nfe;
            }
            this.logger.warning("FindVMTask forcing J9JavaVMPointer to address from system property com.ibm.j9ddr.vmaddr : " + vmAddressString);
            J9JavaVMPointer vm = J9JavaVMPointer.cast(address);
            J9RASHelper.setCachedVM(vm);
            passBackArray[0] = vm.getAddress();
        } else {
            try {
                passBackArray[0] = DataType.getJ9RASPointer().vm().longValue();
            }
            catch (CorruptDataException e) {
                throw new RuntimeException(e);
            }
        }
        this.logger.fine("FindVMTask passing back J9JavaVMPointer: 0x" + Long.toHexString(passBackArray[0]));
    }
}

